package zio.aws.computeoptimizer.model
import scala.jdk.CollectionConverters.*
sealed trait LicenseRecommendationFilterName {
  def unwrap: software.amazon.awssdk.services.computeoptimizer.model.LicenseRecommendationFilterName
}
object LicenseRecommendationFilterName {
  def wrap(
      value: software.amazon.awssdk.services.computeoptimizer.model.LicenseRecommendationFilterName
  ): zio.aws.computeoptimizer.model.LicenseRecommendationFilterName =
    value match {
      case software.amazon.awssdk.services.computeoptimizer.model.LicenseRecommendationFilterName.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.computeoptimizer.model.LicenseRecommendationFilterName.FINDING =>
        val r = Finding
        r
      case software.amazon.awssdk.services.computeoptimizer.model.LicenseRecommendationFilterName.FINDING_REASON_CODE =>
        val r = FindingReasonCode
        r
      case software.amazon.awssdk.services.computeoptimizer.model.LicenseRecommendationFilterName.LICENSE_NAME =>
        val r = LicenseName
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.computeoptimizer.model.LicenseRecommendationFilterName {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.LicenseRecommendationFilterName =
      software.amazon.awssdk.services.computeoptimizer.model.LicenseRecommendationFilterName.UNKNOWN_TO_SDK_VERSION
  }
  case object Finding
      extends zio.aws.computeoptimizer.model.LicenseRecommendationFilterName {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.LicenseRecommendationFilterName =
      software.amazon.awssdk.services.computeoptimizer.model.LicenseRecommendationFilterName.FINDING
  }
  case object FindingReasonCode
      extends zio.aws.computeoptimizer.model.LicenseRecommendationFilterName {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.LicenseRecommendationFilterName =
      software.amazon.awssdk.services.computeoptimizer.model.LicenseRecommendationFilterName.FINDING_REASON_CODE
  }
  case object LicenseName
      extends zio.aws.computeoptimizer.model.LicenseRecommendationFilterName {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.LicenseRecommendationFilterName =
      software.amazon.awssdk.services.computeoptimizer.model.LicenseRecommendationFilterName.LICENSE_NAME
  }
}
