package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.computeoptimizer.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class GetLicenseRecommendationsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    licenseRecommendations: Optional[
      Iterable[zio.aws.computeoptimizer.model.LicenseRecommendation]
    ] = Optional.Absent,
    errors: Optional[
      Iterable[zio.aws.computeoptimizer.model.GetRecommendationError]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.GetLicenseRecommendationsResponse = {
    import GetLicenseRecommendationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.GetLicenseRecommendationsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        licenseRecommendations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.licenseRecommendations)
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.GetLicenseRecommendationsResponse.ReadOnly =
    zio.aws.computeoptimizer.model.GetLicenseRecommendationsResponse
      .wrap(buildAwsValue())
}
object GetLicenseRecommendationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.GetLicenseRecommendationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.GetLicenseRecommendationsResponse =
      zio.aws.computeoptimizer.model.GetLicenseRecommendationsResponse(
        nextToken.map(value => value),
        licenseRecommendations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def licenseRecommendations: Optional[
      List[zio.aws.computeoptimizer.model.LicenseRecommendation.ReadOnly]
    ]
    def errors: Optional[
      List[zio.aws.computeoptimizer.model.GetRecommendationError.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getLicenseRecommendations: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.LicenseRecommendation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "licenseRecommendations",
      licenseRecommendations
    )
    def getErrors: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.GetRecommendationError.ReadOnly
    ]] = AwsError.unwrapOptionField("errors", errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetLicenseRecommendationsResponse
  ) extends zio.aws.computeoptimizer.model.GetLicenseRecommendationsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.computeoptimizer.model.primitives.NextToken(value))
    override val licenseRecommendations: Optional[
      List[zio.aws.computeoptimizer.model.LicenseRecommendation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.licenseRecommendations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.LicenseRecommendation.wrap(item)
        }.toList
      )
    override val errors: Optional[
      List[zio.aws.computeoptimizer.model.GetRecommendationError.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.errors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.GetRecommendationError.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetLicenseRecommendationsResponse
  ): zio.aws.computeoptimizer.model.GetLicenseRecommendationsResponse.ReadOnly =
    new Wrapper(impl)
}
