package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetEffectiveRecommendationPreferencesResponse(
    enhancedInfrastructureMetrics: Optional[
      zio.aws.computeoptimizer.model.EnhancedInfrastructureMetrics
    ] = Optional.Absent,
    externalMetricsPreference: Optional[
      zio.aws.computeoptimizer.model.ExternalMetricsPreference
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.GetEffectiveRecommendationPreferencesResponse = {
    import GetEffectiveRecommendationPreferencesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.GetEffectiveRecommendationPreferencesResponse
      .builder()
      .optionallyWith(enhancedInfrastructureMetrics.map(value => value.unwrap))(
        _.enhancedInfrastructureMetrics
      )
      .optionallyWith(
        externalMetricsPreference.map(value => value.buildAwsValue())
      )(_.externalMetricsPreference)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.GetEffectiveRecommendationPreferencesResponse.ReadOnly =
    zio.aws.computeoptimizer.model.GetEffectiveRecommendationPreferencesResponse
      .wrap(buildAwsValue())
}
object GetEffectiveRecommendationPreferencesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.GetEffectiveRecommendationPreferencesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.GetEffectiveRecommendationPreferencesResponse =
      zio.aws.computeoptimizer.model
        .GetEffectiveRecommendationPreferencesResponse(
          enhancedInfrastructureMetrics.map(value => value),
          externalMetricsPreference.map(value => value.asEditable)
        )
    def enhancedInfrastructureMetrics
        : Optional[zio.aws.computeoptimizer.model.EnhancedInfrastructureMetrics]
    def externalMetricsPreference: Optional[
      zio.aws.computeoptimizer.model.ExternalMetricsPreference.ReadOnly
    ]
    def getEnhancedInfrastructureMetrics: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.EnhancedInfrastructureMetrics
    ] = AwsError.unwrapOptionField(
      "enhancedInfrastructureMetrics",
      enhancedInfrastructureMetrics
    )
    def getExternalMetricsPreference: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.ExternalMetricsPreference.ReadOnly
    ] = AwsError.unwrapOptionField(
      "externalMetricsPreference",
      externalMetricsPreference
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetEffectiveRecommendationPreferencesResponse
  ) extends zio.aws.computeoptimizer.model.GetEffectiveRecommendationPreferencesResponse.ReadOnly {
    override val enhancedInfrastructureMetrics: Optional[
      zio.aws.computeoptimizer.model.EnhancedInfrastructureMetrics
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.enhancedInfrastructureMetrics())
      .map(value =>
        zio.aws.computeoptimizer.model.EnhancedInfrastructureMetrics.wrap(value)
      )
    override val externalMetricsPreference: Optional[
      zio.aws.computeoptimizer.model.ExternalMetricsPreference.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.externalMetricsPreference())
      .map(value =>
        zio.aws.computeoptimizer.model.ExternalMetricsPreference.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetEffectiveRecommendationPreferencesResponse
  ): zio.aws.computeoptimizer.model.GetEffectiveRecommendationPreferencesResponse.ReadOnly =
    new Wrapper(impl)
}
