package zio.aws.computeoptimizer.model
import zio.aws.computeoptimizer.model.primitives.{MetricValue, Timestamp}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ECSServiceProjectedMetric(
    name: Optional[zio.aws.computeoptimizer.model.ECSServiceMetricName] =
      Optional.Absent,
    timestamps: Optional[Iterable[Timestamp]] = Optional.Absent,
    upperBoundValues: Optional[Iterable[MetricValue]] = Optional.Absent,
    lowerBoundValues: Optional[Iterable[MetricValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.ECSServiceProjectedMetric = {
    import ECSServiceProjectedMetric.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.ECSServiceProjectedMetric
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(
        timestamps.map(value =>
          value.map { item =>
            Timestamp.unwrap(item): Instant
          }.asJavaCollection
        )
      )(_.timestamps)
      .optionallyWith(
        upperBoundValues.map(value =>
          value.map { item =>
            MetricValue.unwrap(item): java.lang.Double
          }.asJavaCollection
        )
      )(_.upperBoundValues)
      .optionallyWith(
        lowerBoundValues.map(value =>
          value.map { item =>
            MetricValue.unwrap(item): java.lang.Double
          }.asJavaCollection
        )
      )(_.lowerBoundValues)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.ECSServiceProjectedMetric.ReadOnly =
    zio.aws.computeoptimizer.model.ECSServiceProjectedMetric
      .wrap(buildAwsValue())
}
object ECSServiceProjectedMetric {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.ECSServiceProjectedMetric
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.computeoptimizer.model.ECSServiceProjectedMetric =
      zio.aws.computeoptimizer.model.ECSServiceProjectedMetric(
        name.map(value => value),
        timestamps.map(value => value),
        upperBoundValues.map(value => value),
        lowerBoundValues.map(value => value)
      )
    def name: Optional[zio.aws.computeoptimizer.model.ECSServiceMetricName]
    def timestamps: Optional[List[Timestamp]]
    def upperBoundValues: Optional[List[MetricValue]]
    def lowerBoundValues: Optional[List[MetricValue]]
    def getName: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.ECSServiceMetricName
    ] = AwsError.unwrapOptionField("name", name)
    def getTimestamps: ZIO[Any, AwsError, List[Timestamp]] =
      AwsError.unwrapOptionField("timestamps", timestamps)
    def getUpperBoundValues: ZIO[Any, AwsError, List[MetricValue]] =
      AwsError.unwrapOptionField("upperBoundValues", upperBoundValues)
    def getLowerBoundValues: ZIO[Any, AwsError, List[MetricValue]] =
      AwsError.unwrapOptionField("lowerBoundValues", lowerBoundValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.ECSServiceProjectedMetric
  ) extends zio.aws.computeoptimizer.model.ECSServiceProjectedMetric.ReadOnly {
    override val name
        : Optional[zio.aws.computeoptimizer.model.ECSServiceMetricName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.computeoptimizer.model.ECSServiceMetricName.wrap(value)
        )
    override val timestamps: Optional[List[Timestamp]] = zio.aws.core.internal
      .optionalFromNullable(impl.timestamps())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.primitives.Timestamp(item)
        }.toList
      )
    override val upperBoundValues: Optional[List[MetricValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.upperBoundValues())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.computeoptimizer.model.primitives.MetricValue(item)
          }.toList
        )
    override val lowerBoundValues: Optional[List[MetricValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lowerBoundValues())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.computeoptimizer.model.primitives.MetricValue(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.ECSServiceProjectedMetric
  ): zio.aws.computeoptimizer.model.ECSServiceProjectedMetric.ReadOnly =
    new Wrapper(impl)
}
