package zio.aws.computeoptimizer.model
import scala.jdk.CollectionConverters.*
sealed trait ECSServiceLaunchType {
  def unwrap: software.amazon.awssdk.services.computeoptimizer.model.ECSServiceLaunchType
}
object ECSServiceLaunchType {
  def wrap(
      value: software.amazon.awssdk.services.computeoptimizer.model.ECSServiceLaunchType
  ): zio.aws.computeoptimizer.model.ECSServiceLaunchType = value match {
    case software.amazon.awssdk.services.computeoptimizer.model.ECSServiceLaunchType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ECSServiceLaunchType.EC2 =>
      val r = EC2
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ECSServiceLaunchType.FARGATE =>
      val r = Fargate
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.computeoptimizer.model.ECSServiceLaunchType {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ECSServiceLaunchType =
      software.amazon.awssdk.services.computeoptimizer.model.ECSServiceLaunchType.UNKNOWN_TO_SDK_VERSION
  }
  case object EC2 extends zio.aws.computeoptimizer.model.ECSServiceLaunchType {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ECSServiceLaunchType =
      software.amazon.awssdk.services.computeoptimizer.model.ECSServiceLaunchType.EC2
  }
  case object Fargate
      extends zio.aws.computeoptimizer.model.ECSServiceLaunchType {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ECSServiceLaunchType =
      software.amazon.awssdk.services.computeoptimizer.model.ECSServiceLaunchType.FARGATE
  }
}
