package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.computeoptimizer.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class GetEc2InstanceRecommendationsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    instanceRecommendations: Optional[
      Iterable[zio.aws.computeoptimizer.model.InstanceRecommendation]
    ] = Optional.Absent,
    errors: Optional[
      Iterable[zio.aws.computeoptimizer.model.GetRecommendationError]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.GetEc2InstanceRecommendationsResponse = {
    import GetEc2InstanceRecommendationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.GetEc2InstanceRecommendationsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        instanceRecommendations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceRecommendations)
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.GetEc2InstanceRecommendationsResponse.ReadOnly =
    zio.aws.computeoptimizer.model.GetEc2InstanceRecommendationsResponse
      .wrap(buildAwsValue())
}
object GetEc2InstanceRecommendationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.GetEc2InstanceRecommendationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.GetEc2InstanceRecommendationsResponse =
      zio.aws.computeoptimizer.model.GetEc2InstanceRecommendationsResponse(
        nextToken.map(value => value),
        instanceRecommendations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def instanceRecommendations: Optional[
      List[zio.aws.computeoptimizer.model.InstanceRecommendation.ReadOnly]
    ]
    def errors: Optional[
      List[zio.aws.computeoptimizer.model.GetRecommendationError.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getInstanceRecommendations: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.InstanceRecommendation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "instanceRecommendations",
      instanceRecommendations
    )
    def getErrors: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.GetRecommendationError.ReadOnly
    ]] = AwsError.unwrapOptionField("errors", errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetEc2InstanceRecommendationsResponse
  ) extends zio.aws.computeoptimizer.model.GetEc2InstanceRecommendationsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.computeoptimizer.model.primitives.NextToken(value))
    override val instanceRecommendations: Optional[
      List[zio.aws.computeoptimizer.model.InstanceRecommendation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceRecommendations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.InstanceRecommendation.wrap(item)
        }.toList
      )
    override val errors: Optional[
      List[zio.aws.computeoptimizer.model.GetRecommendationError.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.errors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.GetRecommendationError.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetEc2InstanceRecommendationsResponse
  ): zio.aws.computeoptimizer.model.GetEc2InstanceRecommendationsResponse.ReadOnly =
    new Wrapper(impl)
}
