package zio.aws.computeoptimizer.model
import zio.aws.computeoptimizer.model.primitives.{
  TaskDefinitionArn,
  NullableCpu,
  NullableMemory
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ServiceConfiguration(
    memory: Optional[NullableMemory] = Optional.Absent,
    cpu: Optional[NullableCpu] = Optional.Absent,
    containerConfigurations: Optional[
      Iterable[zio.aws.computeoptimizer.model.ContainerConfiguration]
    ] = Optional.Absent,
    autoScalingConfiguration: Optional[
      zio.aws.computeoptimizer.model.AutoScalingConfiguration
    ] = Optional.Absent,
    taskDefinitionArn: Optional[TaskDefinitionArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.ServiceConfiguration = {
    import ServiceConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.ServiceConfiguration
      .builder()
      .optionallyWith(
        memory.map(value => NullableMemory.unwrap(value): Integer)
      )(_.memory)
      .optionallyWith(cpu.map(value => NullableCpu.unwrap(value): Integer))(
        _.cpu
      )
      .optionallyWith(
        containerConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.containerConfigurations)
      .optionallyWith(autoScalingConfiguration.map(value => value.unwrap))(
        _.autoScalingConfiguration
      )
      .optionallyWith(
        taskDefinitionArn.map(value =>
          TaskDefinitionArn.unwrap(value): java.lang.String
        )
      )(_.taskDefinitionArn)
      .build()
  }
  def asReadOnly: zio.aws.computeoptimizer.model.ServiceConfiguration.ReadOnly =
    zio.aws.computeoptimizer.model.ServiceConfiguration.wrap(buildAwsValue())
}
object ServiceConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.ServiceConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.computeoptimizer.model.ServiceConfiguration =
      zio.aws.computeoptimizer.model.ServiceConfiguration(
        memory.map(value => value),
        cpu.map(value => value),
        containerConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        autoScalingConfiguration.map(value => value),
        taskDefinitionArn.map(value => value)
      )
    def memory: Optional[NullableMemory]
    def cpu: Optional[NullableCpu]
    def containerConfigurations: Optional[
      List[zio.aws.computeoptimizer.model.ContainerConfiguration.ReadOnly]
    ]
    def autoScalingConfiguration
        : Optional[zio.aws.computeoptimizer.model.AutoScalingConfiguration]
    def taskDefinitionArn: Optional[TaskDefinitionArn]
    def getMemory: ZIO[Any, AwsError, NullableMemory] =
      AwsError.unwrapOptionField("memory", memory)
    def getCpu: ZIO[Any, AwsError, NullableCpu] =
      AwsError.unwrapOptionField("cpu", cpu)
    def getContainerConfigurations: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.ContainerConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "containerConfigurations",
      containerConfigurations
    )
    def getAutoScalingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.AutoScalingConfiguration
    ] = AwsError.unwrapOptionField(
      "autoScalingConfiguration",
      autoScalingConfiguration
    )
    def getTaskDefinitionArn: ZIO[Any, AwsError, TaskDefinitionArn] =
      AwsError.unwrapOptionField("taskDefinitionArn", taskDefinitionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.ServiceConfiguration
  ) extends zio.aws.computeoptimizer.model.ServiceConfiguration.ReadOnly {
    override val memory: Optional[NullableMemory] = zio.aws.core.internal
      .optionalFromNullable(impl.memory())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.NullableMemory(value)
      )
    override val cpu: Optional[NullableCpu] = zio.aws.core.internal
      .optionalFromNullable(impl.cpu())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.NullableCpu(value)
      )
    override val containerConfigurations: Optional[
      List[zio.aws.computeoptimizer.model.ContainerConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.containerConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.ContainerConfiguration.wrap(item)
        }.toList
      )
    override val autoScalingConfiguration
        : Optional[zio.aws.computeoptimizer.model.AutoScalingConfiguration] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoScalingConfiguration())
        .map(value =>
          zio.aws.computeoptimizer.model.AutoScalingConfiguration.wrap(value)
        )
    override val taskDefinitionArn: Optional[TaskDefinitionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskDefinitionArn())
        .map(value =>
          zio.aws.computeoptimizer.model.primitives.TaskDefinitionArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.ServiceConfiguration
  ): zio.aws.computeoptimizer.model.ServiceConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
