package zio.aws.computeoptimizer.model
import scala.jdk.CollectionConverters.*
sealed trait EnhancedInfrastructureMetrics {
  def unwrap: software.amazon.awssdk.services.computeoptimizer.model.EnhancedInfrastructureMetrics
}
object EnhancedInfrastructureMetrics {
  def wrap(
      value: software.amazon.awssdk.services.computeoptimizer.model.EnhancedInfrastructureMetrics
  ): zio.aws.computeoptimizer.model.EnhancedInfrastructureMetrics =
    value match {
      case software.amazon.awssdk.services.computeoptimizer.model.EnhancedInfrastructureMetrics.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.computeoptimizer.model.EnhancedInfrastructureMetrics.ACTIVE =>
        val r = Active
        r
      case software.amazon.awssdk.services.computeoptimizer.model.EnhancedInfrastructureMetrics.INACTIVE =>
        val r = Inactive
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.computeoptimizer.model.EnhancedInfrastructureMetrics {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.EnhancedInfrastructureMetrics =
      software.amazon.awssdk.services.computeoptimizer.model.EnhancedInfrastructureMetrics.UNKNOWN_TO_SDK_VERSION
  }
  case object Active
      extends zio.aws.computeoptimizer.model.EnhancedInfrastructureMetrics {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.EnhancedInfrastructureMetrics =
      software.amazon.awssdk.services.computeoptimizer.model.EnhancedInfrastructureMetrics.ACTIVE
  }
  case object Inactive
      extends zio.aws.computeoptimizer.model.EnhancedInfrastructureMetrics {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.EnhancedInfrastructureMetrics =
      software.amazon.awssdk.services.computeoptimizer.model.EnhancedInfrastructureMetrics.INACTIVE
  }
}
