package zio.aws.computeoptimizer.model
import zio.aws.computeoptimizer.model.primitives.{
  LastRefreshTimestamp,
  LookBackPeriodInDays,
  AccountId,
  ServiceArn
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ECSServiceRecommendation(
    serviceArn: Optional[ServiceArn] = Optional.Absent,
    accountId: Optional[AccountId] = Optional.Absent,
    currentServiceConfiguration: Optional[
      zio.aws.computeoptimizer.model.ServiceConfiguration
    ] = Optional.Absent,
    utilizationMetrics: Optional[
      Iterable[zio.aws.computeoptimizer.model.ECSServiceUtilizationMetric]
    ] = Optional.Absent,
    lookbackPeriodInDays: Optional[LookBackPeriodInDays] = Optional.Absent,
    launchType: Optional[zio.aws.computeoptimizer.model.ECSServiceLaunchType] =
      Optional.Absent,
    lastRefreshTimestamp: Optional[LastRefreshTimestamp] = Optional.Absent,
    finding: Optional[
      zio.aws.computeoptimizer.model.ECSServiceRecommendationFinding
    ] = Optional.Absent,
    findingReasonCodes: Optional[Iterable[
      zio.aws.computeoptimizer.model.ECSServiceRecommendationFindingReasonCode
    ]] = Optional.Absent,
    serviceRecommendationOptions: Optional[
      Iterable[zio.aws.computeoptimizer.model.ECSServiceRecommendationOption]
    ] = Optional.Absent,
    currentPerformanceRisk: Optional[
      zio.aws.computeoptimizer.model.CurrentPerformanceRisk
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendation = {
    import ECSServiceRecommendation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendation
      .builder()
      .optionallyWith(
        serviceArn.map(value => ServiceArn.unwrap(value): java.lang.String)
      )(_.serviceArn)
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        currentServiceConfiguration.map(value => value.buildAwsValue())
      )(_.currentServiceConfiguration)
      .optionallyWith(
        utilizationMetrics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.utilizationMetrics)
      .optionallyWith(
        lookbackPeriodInDays.map(value =>
          LookBackPeriodInDays.unwrap(value): java.lang.Double
        )
      )(_.lookbackPeriodInDays)
      .optionallyWith(launchType.map(value => value.unwrap))(_.launchType)
      .optionallyWith(
        lastRefreshTimestamp.map(value =>
          LastRefreshTimestamp.unwrap(value): Instant
        )
      )(_.lastRefreshTimestamp)
      .optionallyWith(finding.map(value => value.unwrap))(_.finding)
      .optionallyWith(
        findingReasonCodes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.findingReasonCodesWithStrings)
      .optionallyWith(
        serviceRecommendationOptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serviceRecommendationOptions)
      .optionallyWith(currentPerformanceRisk.map(value => value.unwrap))(
        _.currentPerformanceRisk
      )
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.ECSServiceRecommendation.ReadOnly =
    zio.aws.computeoptimizer.model.ECSServiceRecommendation
      .wrap(buildAwsValue())
}
object ECSServiceRecommendation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.computeoptimizer.model.ECSServiceRecommendation =
      zio.aws.computeoptimizer.model.ECSServiceRecommendation(
        serviceArn.map(value => value),
        accountId.map(value => value),
        currentServiceConfiguration.map(value => value.asEditable),
        utilizationMetrics.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lookbackPeriodInDays.map(value => value),
        launchType.map(value => value),
        lastRefreshTimestamp.map(value => value),
        finding.map(value => value),
        findingReasonCodes.map(value => value),
        serviceRecommendationOptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        currentPerformanceRisk.map(value => value)
      )
    def serviceArn: Optional[ServiceArn]
    def accountId: Optional[AccountId]
    def currentServiceConfiguration
        : Optional[zio.aws.computeoptimizer.model.ServiceConfiguration.ReadOnly]
    def utilizationMetrics: Optional[
      List[zio.aws.computeoptimizer.model.ECSServiceUtilizationMetric.ReadOnly]
    ]
    def lookbackPeriodInDays: Optional[LookBackPeriodInDays]
    def launchType
        : Optional[zio.aws.computeoptimizer.model.ECSServiceLaunchType]
    def lastRefreshTimestamp: Optional[LastRefreshTimestamp]
    def finding: Optional[
      zio.aws.computeoptimizer.model.ECSServiceRecommendationFinding
    ]
    def findingReasonCodes: Optional[List[
      zio.aws.computeoptimizer.model.ECSServiceRecommendationFindingReasonCode
    ]]
    def serviceRecommendationOptions: Optional[List[
      zio.aws.computeoptimizer.model.ECSServiceRecommendationOption.ReadOnly
    ]]
    def currentPerformanceRisk
        : Optional[zio.aws.computeoptimizer.model.CurrentPerformanceRisk]
    def getServiceArn: ZIO[Any, AwsError, ServiceArn] =
      AwsError.unwrapOptionField("serviceArn", serviceArn)
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getCurrentServiceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.ServiceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "currentServiceConfiguration",
      currentServiceConfiguration
    )
    def getUtilizationMetrics: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.ECSServiceUtilizationMetric.ReadOnly
    ]] = AwsError.unwrapOptionField("utilizationMetrics", utilizationMetrics)
    def getLookbackPeriodInDays: ZIO[Any, AwsError, LookBackPeriodInDays] =
      AwsError.unwrapOptionField("lookbackPeriodInDays", lookbackPeriodInDays)
    def getLaunchType: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.ECSServiceLaunchType
    ] = AwsError.unwrapOptionField("launchType", launchType)
    def getLastRefreshTimestamp: ZIO[Any, AwsError, LastRefreshTimestamp] =
      AwsError.unwrapOptionField("lastRefreshTimestamp", lastRefreshTimestamp)
    def getFinding: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.ECSServiceRecommendationFinding
    ] = AwsError.unwrapOptionField("finding", finding)
    def getFindingReasonCodes: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.ECSServiceRecommendationFindingReasonCode
    ]] = AwsError.unwrapOptionField("findingReasonCodes", findingReasonCodes)
    def getServiceRecommendationOptions: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.ECSServiceRecommendationOption.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "serviceRecommendationOptions",
      serviceRecommendationOptions
    )
    def getCurrentPerformanceRisk: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.CurrentPerformanceRisk
    ] = AwsError.unwrapOptionField(
      "currentPerformanceRisk",
      currentPerformanceRisk
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendation
  ) extends zio.aws.computeoptimizer.model.ECSServiceRecommendation.ReadOnly {
    override val serviceArn: Optional[ServiceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceArn())
      .map(value => zio.aws.computeoptimizer.model.primitives.ServiceArn(value))
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.computeoptimizer.model.primitives.AccountId(value))
    override val currentServiceConfiguration: Optional[
      zio.aws.computeoptimizer.model.ServiceConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.currentServiceConfiguration())
      .map(value =>
        zio.aws.computeoptimizer.model.ServiceConfiguration.wrap(value)
      )
    override val utilizationMetrics: Optional[
      List[zio.aws.computeoptimizer.model.ECSServiceUtilizationMetric.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.utilizationMetrics())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.ECSServiceUtilizationMetric.wrap(item)
        }.toList
      )
    override val lookbackPeriodInDays: Optional[LookBackPeriodInDays] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lookbackPeriodInDays())
        .map(value =>
          zio.aws.computeoptimizer.model.primitives.LookBackPeriodInDays(value)
        )
    override val launchType
        : Optional[zio.aws.computeoptimizer.model.ECSServiceLaunchType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchType())
        .map(value =>
          zio.aws.computeoptimizer.model.ECSServiceLaunchType.wrap(value)
        )
    override val lastRefreshTimestamp: Optional[LastRefreshTimestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastRefreshTimestamp())
        .map(value =>
          zio.aws.computeoptimizer.model.primitives.LastRefreshTimestamp(value)
        )
    override val finding: Optional[
      zio.aws.computeoptimizer.model.ECSServiceRecommendationFinding
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.finding())
      .map(value =>
        zio.aws.computeoptimizer.model.ECSServiceRecommendationFinding
          .wrap(value)
      )
    override val findingReasonCodes: Optional[List[
      zio.aws.computeoptimizer.model.ECSServiceRecommendationFindingReasonCode
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.findingReasonCodes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.ECSServiceRecommendationFindingReasonCode
            .wrap(item)
        }.toList
      )
    override val serviceRecommendationOptions: Optional[List[
      zio.aws.computeoptimizer.model.ECSServiceRecommendationOption.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceRecommendationOptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.ECSServiceRecommendationOption
            .wrap(item)
        }.toList
      )
    override val currentPerformanceRisk
        : Optional[zio.aws.computeoptimizer.model.CurrentPerformanceRisk] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentPerformanceRisk())
        .map(value =>
          zio.aws.computeoptimizer.model.CurrentPerformanceRisk.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendation
  ): zio.aws.computeoptimizer.model.ECSServiceRecommendation.ReadOnly =
    new Wrapper(impl)
}
