package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.computeoptimizer.model.primitives.MetricValue
import scala.jdk.CollectionConverters.*
final case class ECSServiceUtilizationMetric(
    name: Optional[zio.aws.computeoptimizer.model.ECSServiceMetricName] =
      Optional.Absent,
    statistic: Optional[
      zio.aws.computeoptimizer.model.ECSServiceMetricStatistic
    ] = Optional.Absent,
    value: Optional[MetricValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.ECSServiceUtilizationMetric = {
    import ECSServiceUtilizationMetric.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.ECSServiceUtilizationMetric
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(statistic.map(value => value.unwrap))(_.statistic)
      .optionallyWith(
        value.map(value => MetricValue.unwrap(value): java.lang.Double)
      )(_.value)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.ECSServiceUtilizationMetric.ReadOnly =
    zio.aws.computeoptimizer.model.ECSServiceUtilizationMetric
      .wrap(buildAwsValue())
}
object ECSServiceUtilizationMetric {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.ECSServiceUtilizationMetric
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.computeoptimizer.model.ECSServiceUtilizationMetric =
      zio.aws.computeoptimizer.model.ECSServiceUtilizationMetric(
        name.map(value => value),
        statistic.map(value => value),
        value.map(value => value)
      )
    def name: Optional[zio.aws.computeoptimizer.model.ECSServiceMetricName]
    def statistic
        : Optional[zio.aws.computeoptimizer.model.ECSServiceMetricStatistic]
    def value: Optional[MetricValue]
    def getName: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.ECSServiceMetricName
    ] = AwsError.unwrapOptionField("name", name)
    def getStatistic: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.ECSServiceMetricStatistic
    ] = AwsError.unwrapOptionField("statistic", statistic)
    def getValue: ZIO[Any, AwsError, MetricValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.ECSServiceUtilizationMetric
  ) extends zio.aws.computeoptimizer.model.ECSServiceUtilizationMetric.ReadOnly {
    override val name
        : Optional[zio.aws.computeoptimizer.model.ECSServiceMetricName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.computeoptimizer.model.ECSServiceMetricName.wrap(value)
        )
    override val statistic
        : Optional[zio.aws.computeoptimizer.model.ECSServiceMetricStatistic] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statistic())
        .map(value =>
          zio.aws.computeoptimizer.model.ECSServiceMetricStatistic.wrap(value)
        )
    override val value: Optional[MetricValue] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.MetricValue(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.ECSServiceUtilizationMetric
  ): zio.aws.computeoptimizer.model.ECSServiceUtilizationMetric.ReadOnly =
    new Wrapper(impl)
}
