package zio.aws.computeoptimizer.model
import zio.aws.computeoptimizer.model.primitives.{MemorySize, Rank}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class LambdaFunctionMemoryRecommendationOption(
    rank: Optional[Rank] = Optional.Absent,
    memorySize: Optional[MemorySize] = Optional.Absent,
    projectedUtilizationMetrics: Optional[Iterable[
      zio.aws.computeoptimizer.model.LambdaFunctionMemoryProjectedMetric
    ]] = Optional.Absent,
    savingsOpportunity: Optional[
      zio.aws.computeoptimizer.model.SavingsOpportunity
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionMemoryRecommendationOption = {
    import LambdaFunctionMemoryRecommendationOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionMemoryRecommendationOption
      .builder()
      .optionallyWith(rank.map(value => Rank.unwrap(value): Integer))(_.rank)
      .optionallyWith(
        memorySize.map(value => MemorySize.unwrap(value): Integer)
      )(_.memorySize)
      .optionallyWith(
        projectedUtilizationMetrics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.projectedUtilizationMetrics)
      .optionallyWith(savingsOpportunity.map(value => value.buildAwsValue()))(
        _.savingsOpportunity
      )
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.LambdaFunctionMemoryRecommendationOption.ReadOnly =
    zio.aws.computeoptimizer.model.LambdaFunctionMemoryRecommendationOption
      .wrap(buildAwsValue())
}
object LambdaFunctionMemoryRecommendationOption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionMemoryRecommendationOption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.LambdaFunctionMemoryRecommendationOption =
      zio.aws.computeoptimizer.model.LambdaFunctionMemoryRecommendationOption(
        rank.map(value => value),
        memorySize.map(value => value),
        projectedUtilizationMetrics.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        savingsOpportunity.map(value => value.asEditable)
      )
    def rank: Optional[Rank]
    def memorySize: Optional[MemorySize]
    def projectedUtilizationMetrics: Optional[List[
      zio.aws.computeoptimizer.model.LambdaFunctionMemoryProjectedMetric.ReadOnly
    ]]
    def savingsOpportunity
        : Optional[zio.aws.computeoptimizer.model.SavingsOpportunity.ReadOnly]
    def getRank: ZIO[Any, AwsError, Rank] =
      AwsError.unwrapOptionField("rank", rank)
    def getMemorySize: ZIO[Any, AwsError, MemorySize] =
      AwsError.unwrapOptionField("memorySize", memorySize)
    def getProjectedUtilizationMetrics: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.LambdaFunctionMemoryProjectedMetric.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "projectedUtilizationMetrics",
      projectedUtilizationMetrics
    )
    def getSavingsOpportunity: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.SavingsOpportunity.ReadOnly
    ] = AwsError.unwrapOptionField("savingsOpportunity", savingsOpportunity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionMemoryRecommendationOption
  ) extends zio.aws.computeoptimizer.model.LambdaFunctionMemoryRecommendationOption.ReadOnly {
    override val rank: Optional[Rank] = zio.aws.core.internal
      .optionalFromNullable(impl.rank())
      .map(value => zio.aws.computeoptimizer.model.primitives.Rank(value))
    override val memorySize: Optional[MemorySize] = zio.aws.core.internal
      .optionalFromNullable(impl.memorySize())
      .map(value => zio.aws.computeoptimizer.model.primitives.MemorySize(value))
    override val projectedUtilizationMetrics: Optional[List[
      zio.aws.computeoptimizer.model.LambdaFunctionMemoryProjectedMetric.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.projectedUtilizationMetrics())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.LambdaFunctionMemoryProjectedMetric
            .wrap(item)
        }.toList
      )
    override val savingsOpportunity
        : Optional[zio.aws.computeoptimizer.model.SavingsOpportunity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.savingsOpportunity())
        .map(value =>
          zio.aws.computeoptimizer.model.SavingsOpportunity.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionMemoryRecommendationOption
  ): zio.aws.computeoptimizer.model.LambdaFunctionMemoryRecommendationOption.ReadOnly =
    new Wrapper(impl)
}
