package zio.aws.computeoptimizer.model
import zio.aws.computeoptimizer.model.primitives.{Timestamp, Period, ServiceArn}
import java.time.Instant
import zio.aws.core.BuilderHelper
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetEcsServiceRecommendationProjectedMetricsRequest(
    serviceArn: ServiceArn,
    stat: zio.aws.computeoptimizer.model.MetricStatistic,
    period: Period,
    startTime: Timestamp,
    endTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.GetEcsServiceRecommendationProjectedMetricsRequest = {
    import GetEcsServiceRecommendationProjectedMetricsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.GetEcsServiceRecommendationProjectedMetricsRequest
      .builder()
      .serviceArn(ServiceArn.unwrap(serviceArn): java.lang.String)
      .stat(stat.unwrap)
      .period(Period.unwrap(period): Integer)
      .startTime(Timestamp.unwrap(startTime): Instant)
      .endTime(Timestamp.unwrap(endTime): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.GetEcsServiceRecommendationProjectedMetricsRequest.ReadOnly =
    zio.aws.computeoptimizer.model.GetEcsServiceRecommendationProjectedMetricsRequest
      .wrap(buildAwsValue())
}
object GetEcsServiceRecommendationProjectedMetricsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.GetEcsServiceRecommendationProjectedMetricsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.GetEcsServiceRecommendationProjectedMetricsRequest =
      zio.aws.computeoptimizer.model
        .GetEcsServiceRecommendationProjectedMetricsRequest(
          serviceArn,
          stat,
          period,
          startTime,
          endTime
        )
    def serviceArn: ServiceArn
    def stat: zio.aws.computeoptimizer.model.MetricStatistic
    def period: Period
    def startTime: Timestamp
    def endTime: Timestamp
    def getServiceArn: ZIO[Any, Nothing, ServiceArn] = ZIO.succeed(serviceArn)
    def getStat
        : ZIO[Any, Nothing, zio.aws.computeoptimizer.model.MetricStatistic] =
      ZIO.succeed(stat)
    def getPeriod: ZIO[Any, Nothing, Period] = ZIO.succeed(period)
    def getStartTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTime)
    def getEndTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetEcsServiceRecommendationProjectedMetricsRequest
  ) extends zio.aws.computeoptimizer.model.GetEcsServiceRecommendationProjectedMetricsRequest.ReadOnly {
    override val serviceArn: ServiceArn =
      zio.aws.computeoptimizer.model.primitives.ServiceArn(impl.serviceArn())
    override val stat: zio.aws.computeoptimizer.model.MetricStatistic =
      zio.aws.computeoptimizer.model.MetricStatistic.wrap(impl.stat())
    override val period: Period =
      zio.aws.computeoptimizer.model.primitives.Period(impl.period())
    override val startTime: Timestamp =
      zio.aws.computeoptimizer.model.primitives.Timestamp(impl.startTime())
    override val endTime: Timestamp =
      zio.aws.computeoptimizer.model.primitives.Timestamp(impl.endTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetEcsServiceRecommendationProjectedMetricsRequest
  ): zio.aws.computeoptimizer.model.GetEcsServiceRecommendationProjectedMetricsRequest.ReadOnly =
    new Wrapper(impl)
}
