package zio.aws.computeoptimizer.model
import scala.jdk.CollectionConverters.*
sealed trait ECSServiceRecommendationFilterName {
  def unwrap: software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationFilterName
}
object ECSServiceRecommendationFilterName {
  def wrap(
      value: software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationFilterName
  ): zio.aws.computeoptimizer.model.ECSServiceRecommendationFilterName =
    value match {
      case software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationFilterName.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationFilterName.FINDING =>
        val r = Finding
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationFilterName.FINDING_REASON_CODE =>
        val r = FindingReasonCode
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.computeoptimizer.model.ECSServiceRecommendationFilterName {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationFilterName =
      software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationFilterName.UNKNOWN_TO_SDK_VERSION
  }
  case object Finding
      extends zio.aws.computeoptimizer.model.ECSServiceRecommendationFilterName {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationFilterName =
      software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationFilterName.FINDING
  }
  case object FindingReasonCode
      extends zio.aws.computeoptimizer.model.ECSServiceRecommendationFilterName {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationFilterName =
      software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationFilterName.FINDING_REASON_CODE
  }
}
