package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.computeoptimizer.model.primitives.{
  IncludeMemberAccounts,
  AccountId
}
import scala.jdk.CollectionConverters.*
final case class ExportEc2InstanceRecommendationsRequest(
    accountIds: Optional[Iterable[AccountId]] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.computeoptimizer.model.Filter]] =
      Optional.Absent,
    fieldsToExport: Optional[
      Iterable[zio.aws.computeoptimizer.model.ExportableInstanceField]
    ] = Optional.Absent,
    s3DestinationConfig: zio.aws.computeoptimizer.model.S3DestinationConfig,
    fileFormat: Optional[zio.aws.computeoptimizer.model.FileFormat] =
      Optional.Absent,
    includeMemberAccounts: Optional[IncludeMemberAccounts] = Optional.Absent,
    recommendationPreferences: Optional[
      zio.aws.computeoptimizer.model.RecommendationPreferences
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.ExportEc2InstanceRecommendationsRequest = {
    import ExportEc2InstanceRecommendationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.ExportEc2InstanceRecommendationsRequest
      .builder()
      .optionallyWith(
        accountIds.map(value =>
          value.map { item =>
            AccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.accountIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        fieldsToExport.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.fieldsToExportWithStrings)
      .s3DestinationConfig(s3DestinationConfig.buildAwsValue())
      .optionallyWith(fileFormat.map(value => value.unwrap))(_.fileFormat)
      .optionallyWith(
        includeMemberAccounts.map(value =>
          IncludeMemberAccounts.unwrap(value): java.lang.Boolean
        )
      )(_.includeMemberAccounts)
      .optionallyWith(
        recommendationPreferences.map(value => value.buildAwsValue())
      )(_.recommendationPreferences)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.ExportEc2InstanceRecommendationsRequest.ReadOnly =
    zio.aws.computeoptimizer.model.ExportEc2InstanceRecommendationsRequest
      .wrap(buildAwsValue())
}
object ExportEc2InstanceRecommendationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.ExportEc2InstanceRecommendationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.ExportEc2InstanceRecommendationsRequest =
      zio.aws.computeoptimizer.model.ExportEc2InstanceRecommendationsRequest(
        accountIds.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        fieldsToExport.map(value => value),
        s3DestinationConfig.asEditable,
        fileFormat.map(value => value),
        includeMemberAccounts.map(value => value),
        recommendationPreferences.map(value => value.asEditable)
      )
    def accountIds: Optional[List[AccountId]]
    def filters: Optional[List[zio.aws.computeoptimizer.model.Filter.ReadOnly]]
    def fieldsToExport
        : Optional[List[zio.aws.computeoptimizer.model.ExportableInstanceField]]
    def s3DestinationConfig
        : zio.aws.computeoptimizer.model.S3DestinationConfig.ReadOnly
    def fileFormat: Optional[zio.aws.computeoptimizer.model.FileFormat]
    def includeMemberAccounts: Optional[IncludeMemberAccounts]
    def recommendationPreferences: Optional[
      zio.aws.computeoptimizer.model.RecommendationPreferences.ReadOnly
    ]
    def getAccountIds: ZIO[Any, AwsError, List[AccountId]] =
      AwsError.unwrapOptionField("accountIds", accountIds)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.Filter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getFieldsToExport: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.ExportableInstanceField
    ]] = AwsError.unwrapOptionField("fieldsToExport", fieldsToExport)
    def getS3DestinationConfig: ZIO[
      Any,
      Nothing,
      zio.aws.computeoptimizer.model.S3DestinationConfig.ReadOnly
    ] = ZIO.succeed(s3DestinationConfig)
    def getFileFormat
        : ZIO[Any, AwsError, zio.aws.computeoptimizer.model.FileFormat] =
      AwsError.unwrapOptionField("fileFormat", fileFormat)
    def getIncludeMemberAccounts: ZIO[Any, AwsError, IncludeMemberAccounts] =
      AwsError.unwrapOptionField("includeMemberAccounts", includeMemberAccounts)
    def getRecommendationPreferences: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.RecommendationPreferences.ReadOnly
    ] = AwsError.unwrapOptionField(
      "recommendationPreferences",
      recommendationPreferences
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.ExportEc2InstanceRecommendationsRequest
  ) extends zio.aws.computeoptimizer.model.ExportEc2InstanceRecommendationsRequest.ReadOnly {
    override val accountIds: Optional[List[AccountId]] = zio.aws.core.internal
      .optionalFromNullable(impl.accountIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.primitives.AccountId(item)
        }.toList
      )
    override val filters
        : Optional[List[zio.aws.computeoptimizer.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.computeoptimizer.model.Filter.wrap(item)
          }.toList
        )
    override val fieldsToExport: Optional[
      List[zio.aws.computeoptimizer.model.ExportableInstanceField]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.fieldsToExport())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.ExportableInstanceField.wrap(item)
        }.toList
      )
    override val s3DestinationConfig
        : zio.aws.computeoptimizer.model.S3DestinationConfig.ReadOnly =
      zio.aws.computeoptimizer.model.S3DestinationConfig
        .wrap(impl.s3DestinationConfig())
    override val fileFormat
        : Optional[zio.aws.computeoptimizer.model.FileFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileFormat())
        .map(value => zio.aws.computeoptimizer.model.FileFormat.wrap(value))
    override val includeMemberAccounts: Optional[IncludeMemberAccounts] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includeMemberAccounts())
        .map(value =>
          zio.aws.computeoptimizer.model.primitives.IncludeMemberAccounts(value)
        )
    override val recommendationPreferences: Optional[
      zio.aws.computeoptimizer.model.RecommendationPreferences.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.recommendationPreferences())
      .map(value =>
        zio.aws.computeoptimizer.model.RecommendationPreferences.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.ExportEc2InstanceRecommendationsRequest
  ): zio.aws.computeoptimizer.model.ExportEc2InstanceRecommendationsRequest.ReadOnly =
    new Wrapper(impl)
}
