package zio.aws.computeoptimizer.model
import zio.aws.computeoptimizer.model.primitives.{
  MaxResults,
  NextToken,
  AccountId
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetRecommendationSummariesRequest(
    accountIds: Optional[Iterable[AccountId]] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationSummariesRequest = {
    import GetRecommendationSummariesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationSummariesRequest
      .builder()
      .optionallyWith(
        accountIds.map(value =>
          value.map { item =>
            AccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.accountIds)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.GetRecommendationSummariesRequest.ReadOnly =
    zio.aws.computeoptimizer.model.GetRecommendationSummariesRequest
      .wrap(buildAwsValue())
}
object GetRecommendationSummariesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationSummariesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.GetRecommendationSummariesRequest =
      zio.aws.computeoptimizer.model.GetRecommendationSummariesRequest(
        accountIds.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def accountIds: Optional[List[AccountId]]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getAccountIds: ZIO[Any, AwsError, List[AccountId]] =
      AwsError.unwrapOptionField("accountIds", accountIds)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationSummariesRequest
  ) extends zio.aws.computeoptimizer.model.GetRecommendationSummariesRequest.ReadOnly {
    override val accountIds: Optional[List[AccountId]] = zio.aws.core.internal
      .optionalFromNullable(impl.accountIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.primitives.AccountId(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.computeoptimizer.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.computeoptimizer.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationSummariesRequest
  ): zio.aws.computeoptimizer.model.GetRecommendationSummariesRequest.ReadOnly =
    new Wrapper(impl)
}
