package zio.aws.computeoptimizer.model
import scala.jdk.CollectionConverters.*
sealed trait PlatformDifference {
  def unwrap: software.amazon.awssdk.services.computeoptimizer.model.PlatformDifference
}
object PlatformDifference {
  def wrap(
      value: software.amazon.awssdk.services.computeoptimizer.model.PlatformDifference
  ): zio.aws.computeoptimizer.model.PlatformDifference = value match {
    case software.amazon.awssdk.services.computeoptimizer.model.PlatformDifference.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.computeoptimizer.model.PlatformDifference.HYPERVISOR =>
      val r = Hypervisor
      r
    case software.amazon.awssdk.services.computeoptimizer.model.PlatformDifference.NETWORK_INTERFACE =>
      val r = NetworkInterface
      r
    case software.amazon.awssdk.services.computeoptimizer.model.PlatformDifference.STORAGE_INTERFACE =>
      val r = StorageInterface
      r
    case software.amazon.awssdk.services.computeoptimizer.model.PlatformDifference.INSTANCE_STORE_AVAILABILITY =>
      val r = InstanceStoreAvailability
      r
    case software.amazon.awssdk.services.computeoptimizer.model.PlatformDifference.VIRTUALIZATION_TYPE =>
      val r = VirtualizationType
      r
    case software.amazon.awssdk.services.computeoptimizer.model.PlatformDifference.ARCHITECTURE =>
      val r = Architecture
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.computeoptimizer.model.PlatformDifference {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.PlatformDifference =
      software.amazon.awssdk.services.computeoptimizer.model.PlatformDifference.UNKNOWN_TO_SDK_VERSION
  }
  case object Hypervisor
      extends zio.aws.computeoptimizer.model.PlatformDifference {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.PlatformDifference =
      software.amazon.awssdk.services.computeoptimizer.model.PlatformDifference.HYPERVISOR
  }
  case object NetworkInterface
      extends zio.aws.computeoptimizer.model.PlatformDifference {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.PlatformDifference =
      software.amazon.awssdk.services.computeoptimizer.model.PlatformDifference.NETWORK_INTERFACE
  }
  case object StorageInterface
      extends zio.aws.computeoptimizer.model.PlatformDifference {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.PlatformDifference =
      software.amazon.awssdk.services.computeoptimizer.model.PlatformDifference.STORAGE_INTERFACE
  }
  case object InstanceStoreAvailability
      extends zio.aws.computeoptimizer.model.PlatformDifference {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.PlatformDifference =
      software.amazon.awssdk.services.computeoptimizer.model.PlatformDifference.INSTANCE_STORE_AVAILABILITY
  }
  case object VirtualizationType
      extends zio.aws.computeoptimizer.model.PlatformDifference {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.PlatformDifference =
      software.amazon.awssdk.services.computeoptimizer.model.PlatformDifference.VIRTUALIZATION_TYPE
  }
  case object Architecture
      extends zio.aws.computeoptimizer.model.PlatformDifference {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.PlatformDifference =
      software.amazon.awssdk.services.computeoptimizer.model.PlatformDifference.ARCHITECTURE
  }
}
