package zio.aws.computeoptimizer.model
import scala.jdk.CollectionConverters.*
sealed trait LambdaFunctionMetricName {
  def unwrap: software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionMetricName
}
object LambdaFunctionMetricName {
  def wrap(
      value: software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionMetricName
  ): zio.aws.computeoptimizer.model.LambdaFunctionMetricName = value match {
    case software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionMetricName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionMetricName.DURATION =>
      val r = Duration
      r
    case software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionMetricName.MEMORY =>
      val r = Memory
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.computeoptimizer.model.LambdaFunctionMetricName {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionMetricName =
      software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionMetricName.UNKNOWN_TO_SDK_VERSION
  }
  case object Duration
      extends zio.aws.computeoptimizer.model.LambdaFunctionMetricName {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionMetricName =
      software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionMetricName.DURATION
  }
  case object Memory
      extends zio.aws.computeoptimizer.model.LambdaFunctionMetricName {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionMetricName =
      software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionMetricName.MEMORY
  }
}
