package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.computeoptimizer.model.primitives.MetricValue
import scala.jdk.CollectionConverters.*
final case class LambdaFunctionMemoryProjectedMetric(
    name: Optional[
      zio.aws.computeoptimizer.model.LambdaFunctionMemoryMetricName
    ] = Optional.Absent,
    statistic: Optional[
      zio.aws.computeoptimizer.model.LambdaFunctionMemoryMetricStatistic
    ] = Optional.Absent,
    value: Optional[MetricValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionMemoryProjectedMetric = {
    import LambdaFunctionMemoryProjectedMetric.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionMemoryProjectedMetric
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(statistic.map(value => value.unwrap))(_.statistic)
      .optionallyWith(
        value.map(value => MetricValue.unwrap(value): java.lang.Double)
      )(_.value)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.LambdaFunctionMemoryProjectedMetric.ReadOnly =
    zio.aws.computeoptimizer.model.LambdaFunctionMemoryProjectedMetric
      .wrap(buildAwsValue())
}
object LambdaFunctionMemoryProjectedMetric {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionMemoryProjectedMetric
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.LambdaFunctionMemoryProjectedMetric =
      zio.aws.computeoptimizer.model.LambdaFunctionMemoryProjectedMetric(
        name.map(value => value),
        statistic.map(value => value),
        value.map(value => value)
      )
    def name: Optional[
      zio.aws.computeoptimizer.model.LambdaFunctionMemoryMetricName
    ]
    def statistic: Optional[
      zio.aws.computeoptimizer.model.LambdaFunctionMemoryMetricStatistic
    ]
    def value: Optional[MetricValue]
    def getName: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.LambdaFunctionMemoryMetricName
    ] = AwsError.unwrapOptionField("name", name)
    def getStatistic: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.LambdaFunctionMemoryMetricStatistic
    ] = AwsError.unwrapOptionField("statistic", statistic)
    def getValue: ZIO[Any, AwsError, MetricValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionMemoryProjectedMetric
  ) extends zio.aws.computeoptimizer.model.LambdaFunctionMemoryProjectedMetric.ReadOnly {
    override val name: Optional[
      zio.aws.computeoptimizer.model.LambdaFunctionMemoryMetricName
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.computeoptimizer.model.LambdaFunctionMemoryMetricName
          .wrap(value)
      )
    override val statistic: Optional[
      zio.aws.computeoptimizer.model.LambdaFunctionMemoryMetricStatistic
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.statistic())
      .map(value =>
        zio.aws.computeoptimizer.model.LambdaFunctionMemoryMetricStatistic
          .wrap(value)
      )
    override val value: Optional[MetricValue] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.MetricValue(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionMemoryProjectedMetric
  ): zio.aws.computeoptimizer.model.LambdaFunctionMemoryProjectedMetric.ReadOnly =
    new Wrapper(impl)
}
