package zio.aws.computeoptimizer.model
import zio.aws.computeoptimizer.model.primitives.{Rank, PerformanceRisk}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class VolumeRecommendationOption(
    configuration: Optional[
      zio.aws.computeoptimizer.model.VolumeConfiguration
    ] = Optional.Absent,
    performanceRisk: Optional[PerformanceRisk] = Optional.Absent,
    rank: Optional[Rank] = Optional.Absent,
    savingsOpportunity: Optional[
      zio.aws.computeoptimizer.model.SavingsOpportunity
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.VolumeRecommendationOption = {
    import VolumeRecommendationOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.VolumeRecommendationOption
      .builder()
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .optionallyWith(
        performanceRisk.map(value =>
          PerformanceRisk.unwrap(value): java.lang.Double
        )
      )(_.performanceRisk)
      .optionallyWith(rank.map(value => Rank.unwrap(value): Integer))(_.rank)
      .optionallyWith(savingsOpportunity.map(value => value.buildAwsValue()))(
        _.savingsOpportunity
      )
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.VolumeRecommendationOption.ReadOnly =
    zio.aws.computeoptimizer.model.VolumeRecommendationOption
      .wrap(buildAwsValue())
}
object VolumeRecommendationOption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.VolumeRecommendationOption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.computeoptimizer.model.VolumeRecommendationOption =
      zio.aws.computeoptimizer.model.VolumeRecommendationOption(
        configuration.map(value => value.asEditable),
        performanceRisk.map(value => value),
        rank.map(value => value),
        savingsOpportunity.map(value => value.asEditable)
      )
    def configuration
        : Optional[zio.aws.computeoptimizer.model.VolumeConfiguration.ReadOnly]
    def performanceRisk: Optional[PerformanceRisk]
    def rank: Optional[Rank]
    def savingsOpportunity
        : Optional[zio.aws.computeoptimizer.model.SavingsOpportunity.ReadOnly]
    def getConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.VolumeConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("configuration", configuration)
    def getPerformanceRisk: ZIO[Any, AwsError, PerformanceRisk] =
      AwsError.unwrapOptionField("performanceRisk", performanceRisk)
    def getRank: ZIO[Any, AwsError, Rank] =
      AwsError.unwrapOptionField("rank", rank)
    def getSavingsOpportunity: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.SavingsOpportunity.ReadOnly
    ] = AwsError.unwrapOptionField("savingsOpportunity", savingsOpportunity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.VolumeRecommendationOption
  ) extends zio.aws.computeoptimizer.model.VolumeRecommendationOption.ReadOnly {
    override val configuration: Optional[
      zio.aws.computeoptimizer.model.VolumeConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.configuration())
      .map(value =>
        zio.aws.computeoptimizer.model.VolumeConfiguration.wrap(value)
      )
    override val performanceRisk: Optional[PerformanceRisk] =
      zio.aws.core.internal
        .optionalFromNullable(impl.performanceRisk())
        .map(value =>
          zio.aws.computeoptimizer.model.primitives.PerformanceRisk(value)
        )
    override val rank: Optional[Rank] = zio.aws.core.internal
      .optionalFromNullable(impl.rank())
      .map(value => zio.aws.computeoptimizer.model.primitives.Rank(value))
    override val savingsOpportunity
        : Optional[zio.aws.computeoptimizer.model.SavingsOpportunity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.savingsOpportunity())
        .map(value =>
          zio.aws.computeoptimizer.model.SavingsOpportunity.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.VolumeRecommendationOption
  ): zio.aws.computeoptimizer.model.VolumeRecommendationOption.ReadOnly =
    new Wrapper(impl)
}
