package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.computeoptimizer.model.primitives.{
  DestinationKeyPrefix,
  DestinationBucket
}
import scala.jdk.CollectionConverters.*
final case class S3DestinationConfig(
    bucket: Optional[DestinationBucket] = Optional.Absent,
    keyPrefix: Optional[DestinationKeyPrefix] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.S3DestinationConfig = {
    import S3DestinationConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.S3DestinationConfig
      .builder()
      .optionallyWith(
        bucket.map(value => DestinationBucket.unwrap(value): java.lang.String)
      )(_.bucket)
      .optionallyWith(
        keyPrefix.map(value =>
          DestinationKeyPrefix.unwrap(value): java.lang.String
        )
      )(_.keyPrefix)
      .build()
  }
  def asReadOnly: zio.aws.computeoptimizer.model.S3DestinationConfig.ReadOnly =
    zio.aws.computeoptimizer.model.S3DestinationConfig.wrap(buildAwsValue())
}
object S3DestinationConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.S3DestinationConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.computeoptimizer.model.S3DestinationConfig =
      zio.aws.computeoptimizer.model.S3DestinationConfig(
        bucket.map(value => value),
        keyPrefix.map(value => value)
      )
    def bucket: Optional[DestinationBucket]
    def keyPrefix: Optional[DestinationKeyPrefix]
    def getBucket: ZIO[Any, AwsError, DestinationBucket] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getKeyPrefix: ZIO[Any, AwsError, DestinationKeyPrefix] =
      AwsError.unwrapOptionField("keyPrefix", keyPrefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.S3DestinationConfig
  ) extends zio.aws.computeoptimizer.model.S3DestinationConfig.ReadOnly {
    override val bucket: Optional[DestinationBucket] = zio.aws.core.internal
      .optionalFromNullable(impl.bucket())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.DestinationBucket(value)
      )
    override val keyPrefix: Optional[DestinationKeyPrefix] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyPrefix())
        .map(value =>
          zio.aws.computeoptimizer.model.primitives.DestinationKeyPrefix(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.S3DestinationConfig
  ): zio.aws.computeoptimizer.model.S3DestinationConfig.ReadOnly = new Wrapper(
    impl
  )
}
