package zio.aws.computeoptimizer.model
import zio.aws.computeoptimizer.model.primitives.{
  MaxResults,
  NextToken,
  AccountId,
  FunctionArn
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetLambdaFunctionRecommendationsRequest(
    functionArns: Optional[Iterable[FunctionArn]] = Optional.Absent,
    accountIds: Optional[Iterable[AccountId]] = Optional.Absent,
    filters: Optional[Iterable[
      zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFilter
    ]] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.GetLambdaFunctionRecommendationsRequest = {
    import GetLambdaFunctionRecommendationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.GetLambdaFunctionRecommendationsRequest
      .builder()
      .optionallyWith(
        functionArns.map(value =>
          value.map { item =>
            FunctionArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.functionArns)
      .optionallyWith(
        accountIds.map(value =>
          value.map { item =>
            AccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.accountIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.GetLambdaFunctionRecommendationsRequest.ReadOnly =
    zio.aws.computeoptimizer.model.GetLambdaFunctionRecommendationsRequest
      .wrap(buildAwsValue())
}
object GetLambdaFunctionRecommendationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.GetLambdaFunctionRecommendationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.GetLambdaFunctionRecommendationsRequest =
      zio.aws.computeoptimizer.model.GetLambdaFunctionRecommendationsRequest(
        functionArns.map(value => value),
        accountIds.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def functionArns: Optional[List[FunctionArn]]
    def accountIds: Optional[List[AccountId]]
    def filters: Optional[List[
      zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFilter.ReadOnly
    ]]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getFunctionArns: ZIO[Any, AwsError, List[FunctionArn]] =
      AwsError.unwrapOptionField("functionArns", functionArns)
    def getAccountIds: ZIO[Any, AwsError, List[AccountId]] =
      AwsError.unwrapOptionField("accountIds", accountIds)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetLambdaFunctionRecommendationsRequest
  ) extends zio.aws.computeoptimizer.model.GetLambdaFunctionRecommendationsRequest.ReadOnly {
    override val functionArns: Optional[List[FunctionArn]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.functionArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.computeoptimizer.model.primitives.FunctionArn(item)
          }.toList
        )
    override val accountIds: Optional[List[AccountId]] = zio.aws.core.internal
      .optionalFromNullable(impl.accountIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.primitives.AccountId(item)
        }.toList
      )
    override val filters: Optional[List[
      zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFilter.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFilter
            .wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.computeoptimizer.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.computeoptimizer.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetLambdaFunctionRecommendationsRequest
  ): zio.aws.computeoptimizer.model.GetLambdaFunctionRecommendationsRequest.ReadOnly =
    new Wrapper(impl)
}
