package zio.aws.computeoptimizer.model
import scala.jdk.CollectionConverters.*
sealed trait Currency {
  def unwrap: software.amazon.awssdk.services.computeoptimizer.model.Currency
}
object Currency {
  def wrap(
      value: software.amazon.awssdk.services.computeoptimizer.model.Currency
  ): zio.aws.computeoptimizer.model.Currency = value match {
    case software.amazon.awssdk.services.computeoptimizer.model.Currency.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.computeoptimizer.model.Currency.USD =>
      val r = USD
      r
    case software.amazon.awssdk.services.computeoptimizer.model.Currency.CNY =>
      val r = CNY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.computeoptimizer.model.Currency {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.Currency =
      software.amazon.awssdk.services.computeoptimizer.model.Currency.UNKNOWN_TO_SDK_VERSION
  }
  case object USD extends zio.aws.computeoptimizer.model.Currency {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.Currency =
      software.amazon.awssdk.services.computeoptimizer.model.Currency.USD
  }
  case object CNY extends zio.aws.computeoptimizer.model.Currency {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.Currency =
      software.amazon.awssdk.services.computeoptimizer.model.Currency.CNY
  }
}
