package zio.aws.computeoptimizer.model
import zio.aws.computeoptimizer.model.primitives.{
  AccountId,
  FunctionVersion,
  MemorySize,
  LastRefreshTimestamp,
  FunctionArn,
  LookBackPeriodInDays,
  NumberOfInvocations
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class LambdaFunctionRecommendation(
    functionArn: Optional[FunctionArn] = Optional.Absent,
    functionVersion: Optional[FunctionVersion] = Optional.Absent,
    accountId: Optional[AccountId] = Optional.Absent,
    currentMemorySize: Optional[MemorySize] = Optional.Absent,
    numberOfInvocations: Optional[NumberOfInvocations] = Optional.Absent,
    utilizationMetrics: Optional[
      Iterable[zio.aws.computeoptimizer.model.LambdaFunctionUtilizationMetric]
    ] = Optional.Absent,
    lookbackPeriodInDays: Optional[LookBackPeriodInDays] = Optional.Absent,
    lastRefreshTimestamp: Optional[LastRefreshTimestamp] = Optional.Absent,
    finding: Optional[
      zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFinding
    ] = Optional.Absent,
    findingReasonCodes: Optional[Iterable[
      zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFindingReasonCode
    ]] = Optional.Absent,
    memorySizeRecommendationOptions: Optional[Iterable[
      zio.aws.computeoptimizer.model.LambdaFunctionMemoryRecommendationOption
    ]] = Optional.Absent,
    currentPerformanceRisk: Optional[
      zio.aws.computeoptimizer.model.CurrentPerformanceRisk
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendation = {
    import LambdaFunctionRecommendation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendation
      .builder()
      .optionallyWith(
        functionArn.map(value => FunctionArn.unwrap(value): java.lang.String)
      )(_.functionArn)
      .optionallyWith(
        functionVersion.map(value =>
          FunctionVersion.unwrap(value): java.lang.String
        )
      )(_.functionVersion)
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        currentMemorySize.map(value => MemorySize.unwrap(value): Integer)
      )(_.currentMemorySize)
      .optionallyWith(
        numberOfInvocations.map(value =>
          NumberOfInvocations.unwrap(value): java.lang.Long
        )
      )(_.numberOfInvocations)
      .optionallyWith(
        utilizationMetrics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.utilizationMetrics)
      .optionallyWith(
        lookbackPeriodInDays.map(value =>
          LookBackPeriodInDays.unwrap(value): java.lang.Double
        )
      )(_.lookbackPeriodInDays)
      .optionallyWith(
        lastRefreshTimestamp.map(value =>
          LastRefreshTimestamp.unwrap(value): Instant
        )
      )(_.lastRefreshTimestamp)
      .optionallyWith(finding.map(value => value.unwrap))(_.finding)
      .optionallyWith(
        findingReasonCodes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.findingReasonCodesWithStrings)
      .optionallyWith(
        memorySizeRecommendationOptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.memorySizeRecommendationOptions)
      .optionallyWith(currentPerformanceRisk.map(value => value.unwrap))(
        _.currentPerformanceRisk
      )
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.LambdaFunctionRecommendation.ReadOnly =
    zio.aws.computeoptimizer.model.LambdaFunctionRecommendation
      .wrap(buildAwsValue())
}
object LambdaFunctionRecommendation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.LambdaFunctionRecommendation =
      zio.aws.computeoptimizer.model.LambdaFunctionRecommendation(
        functionArn.map(value => value),
        functionVersion.map(value => value),
        accountId.map(value => value),
        currentMemorySize.map(value => value),
        numberOfInvocations.map(value => value),
        utilizationMetrics.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lookbackPeriodInDays.map(value => value),
        lastRefreshTimestamp.map(value => value),
        finding.map(value => value),
        findingReasonCodes.map(value => value),
        memorySizeRecommendationOptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        currentPerformanceRisk.map(value => value)
      )
    def functionArn: Optional[FunctionArn]
    def functionVersion: Optional[FunctionVersion]
    def accountId: Optional[AccountId]
    def currentMemorySize: Optional[MemorySize]
    def numberOfInvocations: Optional[NumberOfInvocations]
    def utilizationMetrics: Optional[List[
      zio.aws.computeoptimizer.model.LambdaFunctionUtilizationMetric.ReadOnly
    ]]
    def lookbackPeriodInDays: Optional[LookBackPeriodInDays]
    def lastRefreshTimestamp: Optional[LastRefreshTimestamp]
    def finding: Optional[
      zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFinding
    ]
    def findingReasonCodes: Optional[List[
      zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFindingReasonCode
    ]]
    def memorySizeRecommendationOptions: Optional[List[
      zio.aws.computeoptimizer.model.LambdaFunctionMemoryRecommendationOption.ReadOnly
    ]]
    def currentPerformanceRisk
        : Optional[zio.aws.computeoptimizer.model.CurrentPerformanceRisk]
    def getFunctionArn: ZIO[Any, AwsError, FunctionArn] =
      AwsError.unwrapOptionField("functionArn", functionArn)
    def getFunctionVersion: ZIO[Any, AwsError, FunctionVersion] =
      AwsError.unwrapOptionField("functionVersion", functionVersion)
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getCurrentMemorySize: ZIO[Any, AwsError, MemorySize] =
      AwsError.unwrapOptionField("currentMemorySize", currentMemorySize)
    def getNumberOfInvocations: ZIO[Any, AwsError, NumberOfInvocations] =
      AwsError.unwrapOptionField("numberOfInvocations", numberOfInvocations)
    def getUtilizationMetrics: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.LambdaFunctionUtilizationMetric.ReadOnly
    ]] = AwsError.unwrapOptionField("utilizationMetrics", utilizationMetrics)
    def getLookbackPeriodInDays: ZIO[Any, AwsError, LookBackPeriodInDays] =
      AwsError.unwrapOptionField("lookbackPeriodInDays", lookbackPeriodInDays)
    def getLastRefreshTimestamp: ZIO[Any, AwsError, LastRefreshTimestamp] =
      AwsError.unwrapOptionField("lastRefreshTimestamp", lastRefreshTimestamp)
    def getFinding: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFinding
    ] = AwsError.unwrapOptionField("finding", finding)
    def getFindingReasonCodes: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFindingReasonCode
    ]] = AwsError.unwrapOptionField("findingReasonCodes", findingReasonCodes)
    def getMemorySizeRecommendationOptions: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.LambdaFunctionMemoryRecommendationOption.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "memorySizeRecommendationOptions",
      memorySizeRecommendationOptions
    )
    def getCurrentPerformanceRisk: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.CurrentPerformanceRisk
    ] = AwsError.unwrapOptionField(
      "currentPerformanceRisk",
      currentPerformanceRisk
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendation
  ) extends zio.aws.computeoptimizer.model.LambdaFunctionRecommendation.ReadOnly {
    override val functionArn: Optional[FunctionArn] = zio.aws.core.internal
      .optionalFromNullable(impl.functionArn())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.FunctionArn(value)
      )
    override val functionVersion: Optional[FunctionVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.functionVersion())
        .map(value =>
          zio.aws.computeoptimizer.model.primitives.FunctionVersion(value)
        )
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.computeoptimizer.model.primitives.AccountId(value))
    override val currentMemorySize: Optional[MemorySize] = zio.aws.core.internal
      .optionalFromNullable(impl.currentMemorySize())
      .map(value => zio.aws.computeoptimizer.model.primitives.MemorySize(value))
    override val numberOfInvocations: Optional[NumberOfInvocations] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfInvocations())
        .map(value =>
          zio.aws.computeoptimizer.model.primitives.NumberOfInvocations(value)
        )
    override val utilizationMetrics: Optional[List[
      zio.aws.computeoptimizer.model.LambdaFunctionUtilizationMetric.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.utilizationMetrics())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.LambdaFunctionUtilizationMetric
            .wrap(item)
        }.toList
      )
    override val lookbackPeriodInDays: Optional[LookBackPeriodInDays] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lookbackPeriodInDays())
        .map(value =>
          zio.aws.computeoptimizer.model.primitives.LookBackPeriodInDays(value)
        )
    override val lastRefreshTimestamp: Optional[LastRefreshTimestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastRefreshTimestamp())
        .map(value =>
          zio.aws.computeoptimizer.model.primitives.LastRefreshTimestamp(value)
        )
    override val finding: Optional[
      zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFinding
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.finding())
      .map(value =>
        zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFinding
          .wrap(value)
      )
    override val findingReasonCodes: Optional[List[
      zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFindingReasonCode
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.findingReasonCodes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFindingReasonCode
            .wrap(item)
        }.toList
      )
    override val memorySizeRecommendationOptions: Optional[List[
      zio.aws.computeoptimizer.model.LambdaFunctionMemoryRecommendationOption.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.memorySizeRecommendationOptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.LambdaFunctionMemoryRecommendationOption
            .wrap(item)
        }.toList
      )
    override val currentPerformanceRisk
        : Optional[zio.aws.computeoptimizer.model.CurrentPerformanceRisk] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentPerformanceRisk())
        .map(value =>
          zio.aws.computeoptimizer.model.CurrentPerformanceRisk.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendation
  ): zio.aws.computeoptimizer.model.LambdaFunctionRecommendation.ReadOnly =
    new Wrapper(impl)
}
