package zio.aws.computeoptimizer.model
import scala.jdk.CollectionConverters.*
sealed trait MetricStatistic {
  def unwrap
      : software.amazon.awssdk.services.computeoptimizer.model.MetricStatistic
}
object MetricStatistic {
  def wrap(
      value: software.amazon.awssdk.services.computeoptimizer.model.MetricStatistic
  ): zio.aws.computeoptimizer.model.MetricStatistic = value match {
    case software.amazon.awssdk.services.computeoptimizer.model.MetricStatistic.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.computeoptimizer.model.MetricStatistic.MAXIMUM =>
      val r = Maximum
      r
    case software.amazon.awssdk.services.computeoptimizer.model.MetricStatistic.AVERAGE =>
      val r = Average
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.computeoptimizer.model.MetricStatistic {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.MetricStatistic =
      software.amazon.awssdk.services.computeoptimizer.model.MetricStatistic.UNKNOWN_TO_SDK_VERSION
  }
  case object Maximum extends zio.aws.computeoptimizer.model.MetricStatistic {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.MetricStatistic =
      software.amazon.awssdk.services.computeoptimizer.model.MetricStatistic.MAXIMUM
  }
  case object Average extends zio.aws.computeoptimizer.model.MetricStatistic {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.MetricStatistic =
      software.amazon.awssdk.services.computeoptimizer.model.MetricStatistic.AVERAGE
  }
}
