package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.computeoptimizer.model.primitives.{VeryLow, Low, Medium, High}
import scala.jdk.CollectionConverters.*
final case class CurrentPerformanceRiskRatings(
    high: Optional[High] = Optional.Absent,
    medium: Optional[Medium] = Optional.Absent,
    low: Optional[Low] = Optional.Absent,
    veryLow: Optional[VeryLow] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.CurrentPerformanceRiskRatings = {
    import CurrentPerformanceRiskRatings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.CurrentPerformanceRiskRatings
      .builder()
      .optionallyWith(high.map(value => High.unwrap(value): java.lang.Long))(
        _.high
      )
      .optionallyWith(
        medium.map(value => Medium.unwrap(value): java.lang.Long)
      )(_.medium)
      .optionallyWith(low.map(value => Low.unwrap(value): java.lang.Long))(
        _.low
      )
      .optionallyWith(
        veryLow.map(value => VeryLow.unwrap(value): java.lang.Long)
      )(_.veryLow)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.CurrentPerformanceRiskRatings.ReadOnly =
    zio.aws.computeoptimizer.model.CurrentPerformanceRiskRatings
      .wrap(buildAwsValue())
}
object CurrentPerformanceRiskRatings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.CurrentPerformanceRiskRatings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.CurrentPerformanceRiskRatings =
      zio.aws.computeoptimizer.model.CurrentPerformanceRiskRatings(
        high.map(value => value),
        medium.map(value => value),
        low.map(value => value),
        veryLow.map(value => value)
      )
    def high: Optional[High]
    def medium: Optional[Medium]
    def low: Optional[Low]
    def veryLow: Optional[VeryLow]
    def getHigh: ZIO[Any, AwsError, High] =
      AwsError.unwrapOptionField("high", high)
    def getMedium: ZIO[Any, AwsError, Medium] =
      AwsError.unwrapOptionField("medium", medium)
    def getLow: ZIO[Any, AwsError, Low] = AwsError.unwrapOptionField("low", low)
    def getVeryLow: ZIO[Any, AwsError, VeryLow] =
      AwsError.unwrapOptionField("veryLow", veryLow)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.CurrentPerformanceRiskRatings
  ) extends zio.aws.computeoptimizer.model.CurrentPerformanceRiskRatings.ReadOnly {
    override val high: Optional[High] = zio.aws.core.internal
      .optionalFromNullable(impl.high())
      .map(value => zio.aws.computeoptimizer.model.primitives.High(value))
    override val medium: Optional[Medium] = zio.aws.core.internal
      .optionalFromNullable(impl.medium())
      .map(value => zio.aws.computeoptimizer.model.primitives.Medium(value))
    override val low: Optional[Low] = zio.aws.core.internal
      .optionalFromNullable(impl.low())
      .map(value => zio.aws.computeoptimizer.model.primitives.Low(value))
    override val veryLow: Optional[VeryLow] = zio.aws.core.internal
      .optionalFromNullable(impl.veryLow())
      .map(value => zio.aws.computeoptimizer.model.primitives.VeryLow(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.CurrentPerformanceRiskRatings
  ): zio.aws.computeoptimizer.model.CurrentPerformanceRiskRatings.ReadOnly =
    new Wrapper(impl)
}
