package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.computeoptimizer.model.primitives.FilterValue
import scala.jdk.CollectionConverters.*
final case class EnrollmentFilter(
    name: Optional[zio.aws.computeoptimizer.model.EnrollmentFilterName] =
      Optional.Absent,
    values: Optional[Iterable[FilterValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.EnrollmentFilter = {
    import EnrollmentFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.EnrollmentFilter
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            FilterValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly: zio.aws.computeoptimizer.model.EnrollmentFilter.ReadOnly =
    zio.aws.computeoptimizer.model.EnrollmentFilter.wrap(buildAwsValue())
}
object EnrollmentFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.EnrollmentFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.computeoptimizer.model.EnrollmentFilter =
      zio.aws.computeoptimizer.model
        .EnrollmentFilter(name.map(value => value), values.map(value => value))
    def name: Optional[zio.aws.computeoptimizer.model.EnrollmentFilterName]
    def values: Optional[List[FilterValue]]
    def getName: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.EnrollmentFilterName
    ] = AwsError.unwrapOptionField("name", name)
    def getValues: ZIO[Any, AwsError, List[FilterValue]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.EnrollmentFilter
  ) extends zio.aws.computeoptimizer.model.EnrollmentFilter.ReadOnly {
    override val name
        : Optional[zio.aws.computeoptimizer.model.EnrollmentFilterName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.computeoptimizer.model.EnrollmentFilterName.wrap(value)
        )
    override val values: Optional[List[FilterValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.values())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.primitives.FilterValue(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.EnrollmentFilter
  ): zio.aws.computeoptimizer.model.EnrollmentFilter.ReadOnly = new Wrapper(
    impl
  )
}
