package zio.aws.computeoptimizer.model
import scala.jdk.CollectionConverters.*
sealed trait EBSMetricName {
  def unwrap
      : software.amazon.awssdk.services.computeoptimizer.model.EBSMetricName
}
object EBSMetricName {
  def wrap(
      value: software.amazon.awssdk.services.computeoptimizer.model.EBSMetricName
  ): zio.aws.computeoptimizer.model.EBSMetricName = value match {
    case software.amazon.awssdk.services.computeoptimizer.model.EBSMetricName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.computeoptimizer.model.EBSMetricName.VOLUME_READ_OPS_PER_SECOND =>
      val r = VolumeReadOpsPerSecond
      r
    case software.amazon.awssdk.services.computeoptimizer.model.EBSMetricName.VOLUME_WRITE_OPS_PER_SECOND =>
      val r = VolumeWriteOpsPerSecond
      r
    case software.amazon.awssdk.services.computeoptimizer.model.EBSMetricName.VOLUME_READ_BYTES_PER_SECOND =>
      val r = VolumeReadBytesPerSecond
      r
    case software.amazon.awssdk.services.computeoptimizer.model.EBSMetricName.VOLUME_WRITE_BYTES_PER_SECOND =>
      val r = VolumeWriteBytesPerSecond
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.computeoptimizer.model.EBSMetricName {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.EBSMetricName =
      software.amazon.awssdk.services.computeoptimizer.model.EBSMetricName.UNKNOWN_TO_SDK_VERSION
  }
  case object VolumeReadOpsPerSecond
      extends zio.aws.computeoptimizer.model.EBSMetricName {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.EBSMetricName =
      software.amazon.awssdk.services.computeoptimizer.model.EBSMetricName.VOLUME_READ_OPS_PER_SECOND
  }
  case object VolumeWriteOpsPerSecond
      extends zio.aws.computeoptimizer.model.EBSMetricName {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.EBSMetricName =
      software.amazon.awssdk.services.computeoptimizer.model.EBSMetricName.VOLUME_WRITE_OPS_PER_SECOND
  }
  case object VolumeReadBytesPerSecond
      extends zio.aws.computeoptimizer.model.EBSMetricName {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.EBSMetricName =
      software.amazon.awssdk.services.computeoptimizer.model.EBSMetricName.VOLUME_READ_BYTES_PER_SECOND
  }
  case object VolumeWriteBytesPerSecond
      extends zio.aws.computeoptimizer.model.EBSMetricName {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.EBSMetricName =
      software.amazon.awssdk.services.computeoptimizer.model.EBSMetricName.VOLUME_WRITE_BYTES_PER_SECOND
  }
}
