package zio.aws.computeoptimizer.model
import scala.jdk.CollectionConverters.*
sealed trait Status {
  def unwrap: software.amazon.awssdk.services.computeoptimizer.model.Status
}
object Status {
  def wrap(
      value: software.amazon.awssdk.services.computeoptimizer.model.Status
  ): zio.aws.computeoptimizer.model.Status = value match {
    case software.amazon.awssdk.services.computeoptimizer.model.Status.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.computeoptimizer.model.Status.ACTIVE =>
      val r = Active
      r
    case software.amazon.awssdk.services.computeoptimizer.model.Status.INACTIVE =>
      val r = Inactive
      r
    case software.amazon.awssdk.services.computeoptimizer.model.Status.PENDING =>
      val r = Pending
      r
    case software.amazon.awssdk.services.computeoptimizer.model.Status.FAILED =>
      val r = Failed
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.computeoptimizer.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.Status =
      software.amazon.awssdk.services.computeoptimizer.model.Status.UNKNOWN_TO_SDK_VERSION
  }
  case object Active extends zio.aws.computeoptimizer.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.Status =
      software.amazon.awssdk.services.computeoptimizer.model.Status.ACTIVE
  }
  case object Inactive extends zio.aws.computeoptimizer.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.Status =
      software.amazon.awssdk.services.computeoptimizer.model.Status.INACTIVE
  }
  case object Pending extends zio.aws.computeoptimizer.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.Status =
      software.amazon.awssdk.services.computeoptimizer.model.Status.PENDING
  }
  case object Failed extends zio.aws.computeoptimizer.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.Status =
      software.amazon.awssdk.services.computeoptimizer.model.Status.FAILED
  }
}
