package zio.aws.computeoptimizer.model
import scala.jdk.CollectionConverters.*
sealed trait InferredWorkloadTypesPreference {
  def unwrap: software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadTypesPreference
}
object InferredWorkloadTypesPreference {
  def wrap(
      value: software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadTypesPreference
  ): zio.aws.computeoptimizer.model.InferredWorkloadTypesPreference =
    value match {
      case software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadTypesPreference.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadTypesPreference.ACTIVE =>
        val r = Active
        r
      case software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadTypesPreference.INACTIVE =>
        val r = Inactive
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.computeoptimizer.model.InferredWorkloadTypesPreference {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadTypesPreference =
      software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadTypesPreference.UNKNOWN_TO_SDK_VERSION
  }
  case object Active
      extends zio.aws.computeoptimizer.model.InferredWorkloadTypesPreference {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadTypesPreference =
      software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadTypesPreference.ACTIVE
  }
  case object Inactive
      extends zio.aws.computeoptimizer.model.InferredWorkloadTypesPreference {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadTypesPreference =
      software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadTypesPreference.INACTIVE
  }
}
