package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.computeoptimizer.model.primitives.FilterValue
import scala.jdk.CollectionConverters.*
final case class JobFilter(
    name: Option[zio.aws.computeoptimizer.model.JobFilterName] = None,
    values: Option[Iterable[FilterValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.JobFilter = {
    import JobFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.JobFilter
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            FilterValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly: zio.aws.computeoptimizer.model.JobFilter.ReadOnly =
    zio.aws.computeoptimizer.model.JobFilter.wrap(buildAwsValue())
}
object JobFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.JobFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.computeoptimizer.model.JobFilter =
      zio.aws.computeoptimizer.model
        .JobFilter(name.map(value => value), values.map(value => value))
    def name: Option[zio.aws.computeoptimizer.model.JobFilterName]
    def values: Option[List[FilterValue]]
    def getName
        : ZIO[Any, AwsError, zio.aws.computeoptimizer.model.JobFilterName] =
      AwsError.unwrapOptionField("name", name)
    def getValues: ZIO[Any, AwsError, List[FilterValue]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.JobFilter
  ) extends zio.aws.computeoptimizer.model.JobFilter.ReadOnly {
    override val name: Option[zio.aws.computeoptimizer.model.JobFilterName] =
      scala
        .Option(impl.name())
        .map(value => zio.aws.computeoptimizer.model.JobFilterName.wrap(value))
    override val values: Option[List[FilterValue]] = scala
      .Option(impl.values())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.primitives.FilterValue(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.JobFilter
  ): zio.aws.computeoptimizer.model.JobFilter.ReadOnly = new Wrapper(impl)
}
