package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RecommendationPreferencesDetail(
    scope: Option[zio.aws.computeoptimizer.model.Scope] = None,
    resourceType: Option[zio.aws.computeoptimizer.model.ResourceType] = None,
    enhancedInfrastructureMetrics: Option[
      zio.aws.computeoptimizer.model.EnhancedInfrastructureMetrics
    ] = None,
    inferredWorkloadTypes: Option[
      zio.aws.computeoptimizer.model.InferredWorkloadTypesPreference
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.RecommendationPreferencesDetail = {
    import RecommendationPreferencesDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.RecommendationPreferencesDetail
      .builder()
      .optionallyWith(scope.map(value => value.buildAwsValue()))(_.scope)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(enhancedInfrastructureMetrics.map(value => value.unwrap))(
        _.enhancedInfrastructureMetrics
      )
      .optionallyWith(inferredWorkloadTypes.map(value => value.unwrap))(
        _.inferredWorkloadTypes
      )
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.RecommendationPreferencesDetail.ReadOnly =
    zio.aws.computeoptimizer.model.RecommendationPreferencesDetail
      .wrap(buildAwsValue())
}
object RecommendationPreferencesDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.RecommendationPreferencesDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.RecommendationPreferencesDetail =
      zio.aws.computeoptimizer.model.RecommendationPreferencesDetail(
        scope.map(value => value.asEditable),
        resourceType.map(value => value),
        enhancedInfrastructureMetrics.map(value => value),
        inferredWorkloadTypes.map(value => value)
      )
    def scope: Option[zio.aws.computeoptimizer.model.Scope.ReadOnly]
    def resourceType: Option[zio.aws.computeoptimizer.model.ResourceType]
    def enhancedInfrastructureMetrics
        : Option[zio.aws.computeoptimizer.model.EnhancedInfrastructureMetrics]
    def inferredWorkloadTypes
        : Option[zio.aws.computeoptimizer.model.InferredWorkloadTypesPreference]
    def getScope
        : ZIO[Any, AwsError, zio.aws.computeoptimizer.model.Scope.ReadOnly] =
      AwsError.unwrapOptionField("scope", scope)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.computeoptimizer.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getEnhancedInfrastructureMetrics: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.EnhancedInfrastructureMetrics
    ] = AwsError.unwrapOptionField(
      "enhancedInfrastructureMetrics",
      enhancedInfrastructureMetrics
    )
    def getInferredWorkloadTypes: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.InferredWorkloadTypesPreference
    ] =
      AwsError.unwrapOptionField("inferredWorkloadTypes", inferredWorkloadTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.RecommendationPreferencesDetail
  ) extends zio.aws.computeoptimizer.model.RecommendationPreferencesDetail.ReadOnly {
    override val scope: Option[zio.aws.computeoptimizer.model.Scope.ReadOnly] =
      scala
        .Option(impl.scope())
        .map(value => zio.aws.computeoptimizer.model.Scope.wrap(value))
    override val resourceType
        : Option[zio.aws.computeoptimizer.model.ResourceType] = scala
      .Option(impl.resourceType())
      .map(value => zio.aws.computeoptimizer.model.ResourceType.wrap(value))
    override val enhancedInfrastructureMetrics
        : Option[zio.aws.computeoptimizer.model.EnhancedInfrastructureMetrics] =
      scala
        .Option(impl.enhancedInfrastructureMetrics())
        .map(value =>
          zio.aws.computeoptimizer.model.EnhancedInfrastructureMetrics
            .wrap(value)
        )
    override val inferredWorkloadTypes: Option[
      zio.aws.computeoptimizer.model.InferredWorkloadTypesPreference
    ] = scala
      .Option(impl.inferredWorkloadTypes())
      .map(value =>
        zio.aws.computeoptimizer.model.InferredWorkloadTypesPreference
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.RecommendationPreferencesDetail
  ): zio.aws.computeoptimizer.model.RecommendationPreferencesDetail.ReadOnly =
    new Wrapper(impl)
}
