package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.computeoptimizer.model.primitives.{MetricValue, Timestamp}
import scala.jdk.CollectionConverters.*
final case class ProjectedMetric(
    name: Option[zio.aws.computeoptimizer.model.MetricName] = None,
    timestamps: Option[Iterable[Timestamp]] = None,
    values: Option[Iterable[MetricValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.ProjectedMetric = {
    import ProjectedMetric.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.ProjectedMetric
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(
        timestamps.map(value =>
          value.map { item =>
            Timestamp.unwrap(item): Instant
          }.asJavaCollection
        )
      )(_.timestamps)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            MetricValue.unwrap(item): java.lang.Double
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly: zio.aws.computeoptimizer.model.ProjectedMetric.ReadOnly =
    zio.aws.computeoptimizer.model.ProjectedMetric.wrap(buildAwsValue())
}
object ProjectedMetric {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.ProjectedMetric
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.computeoptimizer.model.ProjectedMetric =
      zio.aws.computeoptimizer.model.ProjectedMetric(
        name.map(value => value),
        timestamps.map(value => value),
        values.map(value => value)
      )
    def name: Option[zio.aws.computeoptimizer.model.MetricName]
    def timestamps: Option[List[Timestamp]]
    def values: Option[List[MetricValue]]
    def getName: ZIO[Any, AwsError, zio.aws.computeoptimizer.model.MetricName] =
      AwsError.unwrapOptionField("name", name)
    def getTimestamps: ZIO[Any, AwsError, List[Timestamp]] =
      AwsError.unwrapOptionField("timestamps", timestamps)
    def getValues: ZIO[Any, AwsError, List[MetricValue]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.ProjectedMetric
  ) extends zio.aws.computeoptimizer.model.ProjectedMetric.ReadOnly {
    override val name: Option[zio.aws.computeoptimizer.model.MetricName] = scala
      .Option(impl.name())
      .map(value => zio.aws.computeoptimizer.model.MetricName.wrap(value))
    override val timestamps: Option[List[Timestamp]] = scala
      .Option(impl.timestamps())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.primitives.Timestamp(item)
        }.toList
      )
    override val values: Option[List[MetricValue]] = scala
      .Option(impl.values())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.primitives.MetricValue(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.ProjectedMetric
  ): zio.aws.computeoptimizer.model.ProjectedMetric.ReadOnly = new Wrapper(impl)
}
