package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.computeoptimizer.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class GetEc2InstanceRecommendationsResponse(
    nextToken: Option[NextToken] = None,
    instanceRecommendations: Option[
      Iterable[zio.aws.computeoptimizer.model.InstanceRecommendation]
    ] = None,
    errors: Option[
      Iterable[zio.aws.computeoptimizer.model.GetRecommendationError]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.GetEc2InstanceRecommendationsResponse = {
    import GetEc2InstanceRecommendationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.GetEc2InstanceRecommendationsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        instanceRecommendations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceRecommendations)
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.GetEc2InstanceRecommendationsResponse.ReadOnly =
    zio.aws.computeoptimizer.model.GetEc2InstanceRecommendationsResponse
      .wrap(buildAwsValue())
}
object GetEc2InstanceRecommendationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.GetEc2InstanceRecommendationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.GetEc2InstanceRecommendationsResponse =
      zio.aws.computeoptimizer.model.GetEc2InstanceRecommendationsResponse(
        nextToken.map(value => value),
        instanceRecommendations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[NextToken]
    def instanceRecommendations: Option[
      List[zio.aws.computeoptimizer.model.InstanceRecommendation.ReadOnly]
    ]
    def errors: Option[
      List[zio.aws.computeoptimizer.model.GetRecommendationError.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getInstanceRecommendations: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.InstanceRecommendation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "instanceRecommendations",
      instanceRecommendations
    )
    def getErrors: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.GetRecommendationError.ReadOnly
    ]] = AwsError.unwrapOptionField("errors", errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetEc2InstanceRecommendationsResponse
  ) extends zio.aws.computeoptimizer.model.GetEc2InstanceRecommendationsResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.computeoptimizer.model.primitives.NextToken(value))
    override val instanceRecommendations: Option[
      List[zio.aws.computeoptimizer.model.InstanceRecommendation.ReadOnly]
    ] = scala
      .Option(impl.instanceRecommendations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.InstanceRecommendation.wrap(item)
        }.toList
      )
    override val errors: Option[
      List[zio.aws.computeoptimizer.model.GetRecommendationError.ReadOnly]
    ] = scala
      .Option(impl.errors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.GetRecommendationError.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetEc2InstanceRecommendationsResponse
  ): zio.aws.computeoptimizer.model.GetEc2InstanceRecommendationsResponse.ReadOnly =
    new Wrapper(impl)
}
