package zio.aws.computeoptimizer.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.computeoptimizer.model.primitives.{MemorySize, Rank}
import scala.jdk.CollectionConverters.*
final case class LambdaFunctionMemoryRecommendationOption(
    rank: Option[Rank] = None,
    memorySize: Option[MemorySize] = None,
    projectedUtilizationMetrics: Option[Iterable[
      zio.aws.computeoptimizer.model.LambdaFunctionMemoryProjectedMetric
    ]] = None,
    savingsOpportunity: Option[
      zio.aws.computeoptimizer.model.SavingsOpportunity
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionMemoryRecommendationOption = {
    import LambdaFunctionMemoryRecommendationOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionMemoryRecommendationOption
      .builder()
      .optionallyWith(rank.map(value => Rank.unwrap(value): Integer))(_.rank)
      .optionallyWith(
        memorySize.map(value => MemorySize.unwrap(value): Integer)
      )(_.memorySize)
      .optionallyWith(
        projectedUtilizationMetrics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.projectedUtilizationMetrics)
      .optionallyWith(savingsOpportunity.map(value => value.buildAwsValue()))(
        _.savingsOpportunity
      )
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.LambdaFunctionMemoryRecommendationOption.ReadOnly =
    zio.aws.computeoptimizer.model.LambdaFunctionMemoryRecommendationOption
      .wrap(buildAwsValue())
}
object LambdaFunctionMemoryRecommendationOption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionMemoryRecommendationOption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.LambdaFunctionMemoryRecommendationOption =
      zio.aws.computeoptimizer.model.LambdaFunctionMemoryRecommendationOption(
        rank.map(value => value),
        memorySize.map(value => value),
        projectedUtilizationMetrics.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        savingsOpportunity.map(value => value.asEditable)
      )
    def rank: Option[Rank]
    def memorySize: Option[MemorySize]
    def projectedUtilizationMetrics: Option[List[
      zio.aws.computeoptimizer.model.LambdaFunctionMemoryProjectedMetric.ReadOnly
    ]]
    def savingsOpportunity
        : Option[zio.aws.computeoptimizer.model.SavingsOpportunity.ReadOnly]
    def getRank: ZIO[Any, AwsError, Rank] =
      AwsError.unwrapOptionField("rank", rank)
    def getMemorySize: ZIO[Any, AwsError, MemorySize] =
      AwsError.unwrapOptionField("memorySize", memorySize)
    def getProjectedUtilizationMetrics: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.LambdaFunctionMemoryProjectedMetric.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "projectedUtilizationMetrics",
      projectedUtilizationMetrics
    )
    def getSavingsOpportunity: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.SavingsOpportunity.ReadOnly
    ] = AwsError.unwrapOptionField("savingsOpportunity", savingsOpportunity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionMemoryRecommendationOption
  ) extends zio.aws.computeoptimizer.model.LambdaFunctionMemoryRecommendationOption.ReadOnly {
    override val rank: Option[Rank] = scala
      .Option(impl.rank())
      .map(value => zio.aws.computeoptimizer.model.primitives.Rank(value))
    override val memorySize: Option[MemorySize] = scala
      .Option(impl.memorySize())
      .map(value => zio.aws.computeoptimizer.model.primitives.MemorySize(value))
    override val projectedUtilizationMetrics: Option[List[
      zio.aws.computeoptimizer.model.LambdaFunctionMemoryProjectedMetric.ReadOnly
    ]] = scala
      .Option(impl.projectedUtilizationMetrics())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.LambdaFunctionMemoryProjectedMetric
            .wrap(item)
        }.toList
      )
    override val savingsOpportunity
        : Option[zio.aws.computeoptimizer.model.SavingsOpportunity.ReadOnly] =
      scala
        .Option(impl.savingsOpportunity())
        .map(value =>
          zio.aws.computeoptimizer.model.SavingsOpportunity.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionMemoryRecommendationOption
  ): zio.aws.computeoptimizer.model.LambdaFunctionMemoryRecommendationOption.ReadOnly =
    new Wrapper(impl)
}
