package zio.aws.computeoptimizer.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.computeoptimizer.model.primitives.{
  InstanceType,
  MaxSize,
  MinSize,
  DesiredCapacity
}
import scala.jdk.CollectionConverters.*
final case class AutoScalingGroupConfiguration(
    desiredCapacity: Option[DesiredCapacity] = None,
    minSize: Option[MinSize] = None,
    maxSize: Option[MaxSize] = None,
    instanceType: Option[InstanceType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.AutoScalingGroupConfiguration = {
    import AutoScalingGroupConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.AutoScalingGroupConfiguration
      .builder()
      .optionallyWith(
        desiredCapacity.map(value => DesiredCapacity.unwrap(value): Integer)
      )(_.desiredCapacity)
      .optionallyWith(minSize.map(value => MinSize.unwrap(value): Integer))(
        _.minSize
      )
      .optionallyWith(maxSize.map(value => MaxSize.unwrap(value): Integer))(
        _.maxSize
      )
      .optionallyWith(
        instanceType.map(value => InstanceType.unwrap(value): java.lang.String)
      )(_.instanceType)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.AutoScalingGroupConfiguration.ReadOnly =
    zio.aws.computeoptimizer.model.AutoScalingGroupConfiguration
      .wrap(buildAwsValue())
}
object AutoScalingGroupConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.AutoScalingGroupConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.AutoScalingGroupConfiguration =
      zio.aws.computeoptimizer.model.AutoScalingGroupConfiguration(
        desiredCapacity.map(value => value),
        minSize.map(value => value),
        maxSize.map(value => value),
        instanceType.map(value => value)
      )
    def desiredCapacity: Option[DesiredCapacity]
    def minSize: Option[MinSize]
    def maxSize: Option[MaxSize]
    def instanceType: Option[InstanceType]
    def getDesiredCapacity: ZIO[Any, AwsError, DesiredCapacity] =
      AwsError.unwrapOptionField("desiredCapacity", desiredCapacity)
    def getMinSize: ZIO[Any, AwsError, MinSize] =
      AwsError.unwrapOptionField("minSize", minSize)
    def getMaxSize: ZIO[Any, AwsError, MaxSize] =
      AwsError.unwrapOptionField("maxSize", maxSize)
    def getInstanceType: ZIO[Any, AwsError, InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.AutoScalingGroupConfiguration
  ) extends zio.aws.computeoptimizer.model.AutoScalingGroupConfiguration.ReadOnly {
    override val desiredCapacity: Option[DesiredCapacity] = scala
      .Option(impl.desiredCapacity())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.DesiredCapacity(value)
      )
    override val minSize: Option[MinSize] = scala
      .Option(impl.minSize())
      .map(value => zio.aws.computeoptimizer.model.primitives.MinSize(value))
    override val maxSize: Option[MaxSize] = scala
      .Option(impl.maxSize())
      .map(value => zio.aws.computeoptimizer.model.primitives.MaxSize(value))
    override val instanceType: Option[InstanceType] = scala
      .Option(impl.instanceType())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.InstanceType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.AutoScalingGroupConfiguration
  ): zio.aws.computeoptimizer.model.AutoScalingGroupConfiguration.ReadOnly =
    new Wrapper(impl)
}
