package zio.aws.computeoptimizer.model
import scala.jdk.CollectionConverters.*
sealed trait CurrentPerformanceRisk {
  def unwrap: software.amazon.awssdk.services.computeoptimizer.model.CurrentPerformanceRisk
}
object CurrentPerformanceRisk {
  def wrap(
      value: software.amazon.awssdk.services.computeoptimizer.model.CurrentPerformanceRisk
  ): zio.aws.computeoptimizer.model.CurrentPerformanceRisk = value match {
    case software.amazon.awssdk.services.computeoptimizer.model.CurrentPerformanceRisk.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.computeoptimizer.model.CurrentPerformanceRisk.VERY_LOW =>
      val r = VeryLow
      r
    case software.amazon.awssdk.services.computeoptimizer.model.CurrentPerformanceRisk.LOW =>
      val r = Low
      r
    case software.amazon.awssdk.services.computeoptimizer.model.CurrentPerformanceRisk.MEDIUM =>
      val r = Medium
      r
    case software.amazon.awssdk.services.computeoptimizer.model.CurrentPerformanceRisk.HIGH =>
      val r = High
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.computeoptimizer.model.CurrentPerformanceRisk {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.CurrentPerformanceRisk =
      software.amazon.awssdk.services.computeoptimizer.model.CurrentPerformanceRisk.UNKNOWN_TO_SDK_VERSION
  }
  case object VeryLow
      extends zio.aws.computeoptimizer.model.CurrentPerformanceRisk {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.CurrentPerformanceRisk =
      software.amazon.awssdk.services.computeoptimizer.model.CurrentPerformanceRisk.VERY_LOW
  }
  case object Low
      extends zio.aws.computeoptimizer.model.CurrentPerformanceRisk {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.CurrentPerformanceRisk =
      software.amazon.awssdk.services.computeoptimizer.model.CurrentPerformanceRisk.LOW
  }
  case object Medium
      extends zio.aws.computeoptimizer.model.CurrentPerformanceRisk {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.CurrentPerformanceRisk =
      software.amazon.awssdk.services.computeoptimizer.model.CurrentPerformanceRisk.MEDIUM
  }
  case object High
      extends zio.aws.computeoptimizer.model.CurrentPerformanceRisk {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.CurrentPerformanceRisk =
      software.amazon.awssdk.services.computeoptimizer.model.CurrentPerformanceRisk.HIGH
  }
}
