package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.computeoptimizer.model.primitives.{
  AutoScalingGroupArn,
  AccountId,
  LastRefreshTimestamp,
  LookBackPeriodInDays,
  AutoScalingGroupName
}
import scala.jdk.CollectionConverters.*
final case class AutoScalingGroupRecommendation(
    accountId: Option[AccountId] = None,
    autoScalingGroupArn: Option[AutoScalingGroupArn] = None,
    autoScalingGroupName: Option[AutoScalingGroupName] = None,
    finding: Option[zio.aws.computeoptimizer.model.Finding] = None,
    utilizationMetrics: Option[
      Iterable[zio.aws.computeoptimizer.model.UtilizationMetric]
    ] = None,
    lookBackPeriodInDays: Option[LookBackPeriodInDays] = None,
    currentConfiguration: Option[
      zio.aws.computeoptimizer.model.AutoScalingGroupConfiguration
    ] = None,
    recommendationOptions: Option[Iterable[
      zio.aws.computeoptimizer.model.AutoScalingGroupRecommendationOption
    ]] = None,
    lastRefreshTimestamp: Option[LastRefreshTimestamp] = None,
    currentPerformanceRisk: Option[
      zio.aws.computeoptimizer.model.CurrentPerformanceRisk
    ] = None,
    effectiveRecommendationPreferences: Option[
      zio.aws.computeoptimizer.model.EffectiveRecommendationPreferences
    ] = None,
    inferredWorkloadTypes: Option[
      Iterable[zio.aws.computeoptimizer.model.InferredWorkloadType]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.AutoScalingGroupRecommendation = {
    import AutoScalingGroupRecommendation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.AutoScalingGroupRecommendation
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        autoScalingGroupArn.map(value =>
          AutoScalingGroupArn.unwrap(value): java.lang.String
        )
      )(_.autoScalingGroupArn)
      .optionallyWith(
        autoScalingGroupName.map(value =>
          AutoScalingGroupName.unwrap(value): java.lang.String
        )
      )(_.autoScalingGroupName)
      .optionallyWith(finding.map(value => value.unwrap))(_.finding)
      .optionallyWith(
        utilizationMetrics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.utilizationMetrics)
      .optionallyWith(
        lookBackPeriodInDays.map(value =>
          LookBackPeriodInDays.unwrap(value): java.lang.Double
        )
      )(_.lookBackPeriodInDays)
      .optionallyWith(currentConfiguration.map(value => value.buildAwsValue()))(
        _.currentConfiguration
      )
      .optionallyWith(
        recommendationOptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recommendationOptions)
      .optionallyWith(
        lastRefreshTimestamp.map(value =>
          LastRefreshTimestamp.unwrap(value): Instant
        )
      )(_.lastRefreshTimestamp)
      .optionallyWith(currentPerformanceRisk.map(value => value.unwrap))(
        _.currentPerformanceRisk
      )
      .optionallyWith(
        effectiveRecommendationPreferences.map(value => value.buildAwsValue())
      )(_.effectiveRecommendationPreferences)
      .optionallyWith(
        inferredWorkloadTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.inferredWorkloadTypesWithStrings)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.AutoScalingGroupRecommendation.ReadOnly =
    zio.aws.computeoptimizer.model.AutoScalingGroupRecommendation
      .wrap(buildAwsValue())
}
object AutoScalingGroupRecommendation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.AutoScalingGroupRecommendation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.AutoScalingGroupRecommendation =
      zio.aws.computeoptimizer.model.AutoScalingGroupRecommendation(
        accountId.map(value => value),
        autoScalingGroupArn.map(value => value),
        autoScalingGroupName.map(value => value),
        finding.map(value => value),
        utilizationMetrics.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lookBackPeriodInDays.map(value => value),
        currentConfiguration.map(value => value.asEditable),
        recommendationOptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lastRefreshTimestamp.map(value => value),
        currentPerformanceRisk.map(value => value),
        effectiveRecommendationPreferences.map(value => value.asEditable),
        inferredWorkloadTypes.map(value => value)
      )
    def accountId: Option[AccountId]
    def autoScalingGroupArn: Option[AutoScalingGroupArn]
    def autoScalingGroupName: Option[AutoScalingGroupName]
    def finding: Option[zio.aws.computeoptimizer.model.Finding]
    def utilizationMetrics: Option[
      List[zio.aws.computeoptimizer.model.UtilizationMetric.ReadOnly]
    ]
    def lookBackPeriodInDays: Option[LookBackPeriodInDays]
    def currentConfiguration: Option[
      zio.aws.computeoptimizer.model.AutoScalingGroupConfiguration.ReadOnly
    ]
    def recommendationOptions: Option[List[
      zio.aws.computeoptimizer.model.AutoScalingGroupRecommendationOption.ReadOnly
    ]]
    def lastRefreshTimestamp: Option[LastRefreshTimestamp]
    def currentPerformanceRisk
        : Option[zio.aws.computeoptimizer.model.CurrentPerformanceRisk]
    def effectiveRecommendationPreferences: Option[
      zio.aws.computeoptimizer.model.EffectiveRecommendationPreferences.ReadOnly
    ]
    def inferredWorkloadTypes
        : Option[List[zio.aws.computeoptimizer.model.InferredWorkloadType]]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getAutoScalingGroupArn: ZIO[Any, AwsError, AutoScalingGroupArn] =
      AwsError.unwrapOptionField("autoScalingGroupArn", autoScalingGroupArn)
    def getAutoScalingGroupName: ZIO[Any, AwsError, AutoScalingGroupName] =
      AwsError.unwrapOptionField("autoScalingGroupName", autoScalingGroupName)
    def getFinding: ZIO[Any, AwsError, zio.aws.computeoptimizer.model.Finding] =
      AwsError.unwrapOptionField("finding", finding)
    def getUtilizationMetrics: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.UtilizationMetric.ReadOnly
    ]] = AwsError.unwrapOptionField("utilizationMetrics", utilizationMetrics)
    def getLookBackPeriodInDays: ZIO[Any, AwsError, LookBackPeriodInDays] =
      AwsError.unwrapOptionField("lookBackPeriodInDays", lookBackPeriodInDays)
    def getCurrentConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.AutoScalingGroupConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("currentConfiguration", currentConfiguration)
    def getRecommendationOptions: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.AutoScalingGroupRecommendationOption.ReadOnly
    ]] =
      AwsError.unwrapOptionField("recommendationOptions", recommendationOptions)
    def getLastRefreshTimestamp: ZIO[Any, AwsError, LastRefreshTimestamp] =
      AwsError.unwrapOptionField("lastRefreshTimestamp", lastRefreshTimestamp)
    def getCurrentPerformanceRisk: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.CurrentPerformanceRisk
    ] = AwsError.unwrapOptionField(
      "currentPerformanceRisk",
      currentPerformanceRisk
    )
    def getEffectiveRecommendationPreferences: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.EffectiveRecommendationPreferences.ReadOnly
    ] = AwsError.unwrapOptionField(
      "effectiveRecommendationPreferences",
      effectiveRecommendationPreferences
    )
    def getInferredWorkloadTypes: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.InferredWorkloadType
    ]] =
      AwsError.unwrapOptionField("inferredWorkloadTypes", inferredWorkloadTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.AutoScalingGroupRecommendation
  ) extends zio.aws.computeoptimizer.model.AutoScalingGroupRecommendation.ReadOnly {
    override val accountId: Option[AccountId] = scala
      .Option(impl.accountId())
      .map(value => zio.aws.computeoptimizer.model.primitives.AccountId(value))
    override val autoScalingGroupArn: Option[AutoScalingGroupArn] = scala
      .Option(impl.autoScalingGroupArn())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.AutoScalingGroupArn(value)
      )
    override val autoScalingGroupName: Option[AutoScalingGroupName] = scala
      .Option(impl.autoScalingGroupName())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.AutoScalingGroupName(value)
      )
    override val finding: Option[zio.aws.computeoptimizer.model.Finding] = scala
      .Option(impl.finding())
      .map(value => zio.aws.computeoptimizer.model.Finding.wrap(value))
    override val utilizationMetrics: Option[
      List[zio.aws.computeoptimizer.model.UtilizationMetric.ReadOnly]
    ] = scala
      .Option(impl.utilizationMetrics())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.UtilizationMetric.wrap(item)
        }.toList
      )
    override val lookBackPeriodInDays: Option[LookBackPeriodInDays] = scala
      .Option(impl.lookBackPeriodInDays())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.LookBackPeriodInDays(value)
      )
    override val currentConfiguration: Option[
      zio.aws.computeoptimizer.model.AutoScalingGroupConfiguration.ReadOnly
    ] = scala
      .Option(impl.currentConfiguration())
      .map(value =>
        zio.aws.computeoptimizer.model.AutoScalingGroupConfiguration.wrap(value)
      )
    override val recommendationOptions: Option[List[
      zio.aws.computeoptimizer.model.AutoScalingGroupRecommendationOption.ReadOnly
    ]] = scala
      .Option(impl.recommendationOptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.AutoScalingGroupRecommendationOption
            .wrap(item)
        }.toList
      )
    override val lastRefreshTimestamp: Option[LastRefreshTimestamp] = scala
      .Option(impl.lastRefreshTimestamp())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.LastRefreshTimestamp(value)
      )
    override val currentPerformanceRisk
        : Option[zio.aws.computeoptimizer.model.CurrentPerformanceRisk] = scala
      .Option(impl.currentPerformanceRisk())
      .map(value =>
        zio.aws.computeoptimizer.model.CurrentPerformanceRisk.wrap(value)
      )
    override val effectiveRecommendationPreferences: Option[
      zio.aws.computeoptimizer.model.EffectiveRecommendationPreferences.ReadOnly
    ] = scala
      .Option(impl.effectiveRecommendationPreferences())
      .map(value =>
        zio.aws.computeoptimizer.model.EffectiveRecommendationPreferences
          .wrap(value)
      )
    override val inferredWorkloadTypes
        : Option[List[zio.aws.computeoptimizer.model.InferredWorkloadType]] =
      scala
        .Option(impl.inferredWorkloadTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.computeoptimizer.model.InferredWorkloadType.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.AutoScalingGroupRecommendation
  ): zio.aws.computeoptimizer.model.AutoScalingGroupRecommendation.ReadOnly =
    new Wrapper(impl)
}
