package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.computeoptimizer.model.primitives.AccountId
import scala.jdk.CollectionConverters.*
final case class RecommendationSummary(
    summaries: Option[Iterable[zio.aws.computeoptimizer.model.Summary]] = None,
    recommendationResourceType: Option[
      zio.aws.computeoptimizer.model.RecommendationSourceType
    ] = None,
    accountId: Option[AccountId] = None,
    savingsOpportunity: Option[
      zio.aws.computeoptimizer.model.SavingsOpportunity
    ] = None,
    currentPerformanceRiskRatings: Option[
      zio.aws.computeoptimizer.model.CurrentPerformanceRiskRatings
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.RecommendationSummary = {
    import RecommendationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.RecommendationSummary
      .builder()
      .optionallyWith(
        summaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.summaries)
      .optionallyWith(recommendationResourceType.map(value => value.unwrap))(
        _.recommendationResourceType
      )
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(savingsOpportunity.map(value => value.buildAwsValue()))(
        _.savingsOpportunity
      )
      .optionallyWith(
        currentPerformanceRiskRatings.map(value => value.buildAwsValue())
      )(_.currentPerformanceRiskRatings)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.RecommendationSummary.ReadOnly =
    zio.aws.computeoptimizer.model.RecommendationSummary.wrap(buildAwsValue())
}
object RecommendationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.RecommendationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.computeoptimizer.model.RecommendationSummary =
      zio.aws.computeoptimizer.model.RecommendationSummary(
        summaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        recommendationResourceType.map(value => value),
        accountId.map(value => value),
        savingsOpportunity.map(value => value.asEditable),
        currentPerformanceRiskRatings.map(value => value.asEditable)
      )
    def summaries: Option[List[zio.aws.computeoptimizer.model.Summary.ReadOnly]]
    def recommendationResourceType
        : Option[zio.aws.computeoptimizer.model.RecommendationSourceType]
    def accountId: Option[AccountId]
    def savingsOpportunity
        : Option[zio.aws.computeoptimizer.model.SavingsOpportunity.ReadOnly]
    def currentPerformanceRiskRatings: Option[
      zio.aws.computeoptimizer.model.CurrentPerformanceRiskRatings.ReadOnly
    ]
    def getSummaries: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.Summary.ReadOnly
    ]] = AwsError.unwrapOptionField("summaries", summaries)
    def getRecommendationResourceType: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.RecommendationSourceType
    ] = AwsError.unwrapOptionField(
      "recommendationResourceType",
      recommendationResourceType
    )
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getSavingsOpportunity: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.SavingsOpportunity.ReadOnly
    ] = AwsError.unwrapOptionField("savingsOpportunity", savingsOpportunity)
    def getCurrentPerformanceRiskRatings: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.CurrentPerformanceRiskRatings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "currentPerformanceRiskRatings",
      currentPerformanceRiskRatings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.RecommendationSummary
  ) extends zio.aws.computeoptimizer.model.RecommendationSummary.ReadOnly {
    override val summaries
        : Option[List[zio.aws.computeoptimizer.model.Summary.ReadOnly]] = scala
      .Option(impl.summaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.Summary.wrap(item)
        }.toList
      )
    override val recommendationResourceType
        : Option[zio.aws.computeoptimizer.model.RecommendationSourceType] =
      scala
        .Option(impl.recommendationResourceType())
        .map(value =>
          zio.aws.computeoptimizer.model.RecommendationSourceType.wrap(value)
        )
    override val accountId: Option[AccountId] = scala
      .Option(impl.accountId())
      .map(value => zio.aws.computeoptimizer.model.primitives.AccountId(value))
    override val savingsOpportunity
        : Option[zio.aws.computeoptimizer.model.SavingsOpportunity.ReadOnly] =
      scala
        .Option(impl.savingsOpportunity())
        .map(value =>
          zio.aws.computeoptimizer.model.SavingsOpportunity.wrap(value)
        )
    override val currentPerformanceRiskRatings: Option[
      zio.aws.computeoptimizer.model.CurrentPerformanceRiskRatings.ReadOnly
    ] = scala
      .Option(impl.currentPerformanceRiskRatings())
      .map(value =>
        zio.aws.computeoptimizer.model.CurrentPerformanceRiskRatings.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.RecommendationSummary
  ): zio.aws.computeoptimizer.model.RecommendationSummary.ReadOnly =
    new Wrapper(impl)
}
