package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.computeoptimizer.model.primitives.{Message, Code, Identifier}
import scala.jdk.CollectionConverters.*
final case class GetRecommendationError(
    identifier: Option[Identifier] = None,
    code: Option[Code] = None,
    message: Option[Message] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationError = {
    import GetRecommendationError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationError
      .builder()
      .optionallyWith(
        identifier.map(value => Identifier.unwrap(value): java.lang.String)
      )(_.identifier)
      .optionallyWith(code.map(value => Code.unwrap(value): java.lang.String))(
        _.code
      )
      .optionallyWith(
        message.map(value => Message.unwrap(value): java.lang.String)
      )(_.message)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.GetRecommendationError.ReadOnly =
    zio.aws.computeoptimizer.model.GetRecommendationError.wrap(buildAwsValue())
}
object GetRecommendationError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.computeoptimizer.model.GetRecommendationError =
      zio.aws.computeoptimizer.model.GetRecommendationError(
        identifier.map(value => value),
        code.map(value => value),
        message.map(value => value)
      )
    def identifier: Option[Identifier]
    def code: Option[Code]
    def message: Option[Message]
    def getIdentifier: ZIO[Any, AwsError, Identifier] =
      AwsError.unwrapOptionField("identifier", identifier)
    def getCode: ZIO[Any, AwsError, Code] =
      AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationError
  ) extends zio.aws.computeoptimizer.model.GetRecommendationError.ReadOnly {
    override val identifier: Option[Identifier] = scala
      .Option(impl.identifier())
      .map(value => zio.aws.computeoptimizer.model.primitives.Identifier(value))
    override val code: Option[Code] = scala
      .Option(impl.code())
      .map(value => zio.aws.computeoptimizer.model.primitives.Code(value))
    override val message: Option[Message] = scala
      .Option(impl.message())
      .map(value => zio.aws.computeoptimizer.model.primitives.Message(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationError
  ): zio.aws.computeoptimizer.model.GetRecommendationError.ReadOnly =
    new Wrapper(impl)
}
