package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.computeoptimizer.model.primitives.StatusReason
import scala.jdk.CollectionConverters.*
final case class UpdateEnrollmentStatusResponse(
    status: Option[zio.aws.computeoptimizer.model.Status] = None,
    statusReason: Option[StatusReason] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.UpdateEnrollmentStatusResponse = {
    import UpdateEnrollmentStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.UpdateEnrollmentStatusResponse
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusReason.map(value => StatusReason.unwrap(value): java.lang.String)
      )(_.statusReason)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.UpdateEnrollmentStatusResponse.ReadOnly =
    zio.aws.computeoptimizer.model.UpdateEnrollmentStatusResponse
      .wrap(buildAwsValue())
}
object UpdateEnrollmentStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.UpdateEnrollmentStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.UpdateEnrollmentStatusResponse =
      zio.aws.computeoptimizer.model.UpdateEnrollmentStatusResponse(
        status.map(value => value),
        statusReason.map(value => value)
      )
    def status: Option[zio.aws.computeoptimizer.model.Status]
    def statusReason: Option[StatusReason]
    def getStatus: ZIO[Any, AwsError, zio.aws.computeoptimizer.model.Status] =
      AwsError.unwrapOptionField("status", status)
    def getStatusReason: ZIO[Any, AwsError, StatusReason] =
      AwsError.unwrapOptionField("statusReason", statusReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.UpdateEnrollmentStatusResponse
  ) extends zio.aws.computeoptimizer.model.UpdateEnrollmentStatusResponse.ReadOnly {
    override val status: Option[zio.aws.computeoptimizer.model.Status] = scala
      .Option(impl.status())
      .map(value => zio.aws.computeoptimizer.model.Status.wrap(value))
    override val statusReason: Option[StatusReason] = scala
      .Option(impl.statusReason())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.StatusReason(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.UpdateEnrollmentStatusResponse
  ): zio.aws.computeoptimizer.model.UpdateEnrollmentStatusResponse.ReadOnly =
    new Wrapper(impl)
}
