package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.computeoptimizer.model.primitives.MetricValue
import scala.jdk.CollectionConverters.*
final case class UtilizationMetric(
    name: Option[zio.aws.computeoptimizer.model.MetricName] = None,
    statistic: Option[zio.aws.computeoptimizer.model.MetricStatistic] = None,
    value: Option[MetricValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.UtilizationMetric = {
    import UtilizationMetric.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.UtilizationMetric
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(statistic.map(value => value.unwrap))(_.statistic)
      .optionallyWith(
        value.map(value => MetricValue.unwrap(value): java.lang.Double)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.computeoptimizer.model.UtilizationMetric.ReadOnly =
    zio.aws.computeoptimizer.model.UtilizationMetric.wrap(buildAwsValue())
}
object UtilizationMetric {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.UtilizationMetric
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.computeoptimizer.model.UtilizationMetric =
      zio.aws.computeoptimizer.model.UtilizationMetric(
        name.map(value => value),
        statistic.map(value => value),
        value.map(value => value)
      )
    def name: Option[zio.aws.computeoptimizer.model.MetricName]
    def statistic: Option[zio.aws.computeoptimizer.model.MetricStatistic]
    def value: Option[MetricValue]
    def getName: ZIO[Any, AwsError, zio.aws.computeoptimizer.model.MetricName] =
      AwsError.unwrapOptionField("name", name)
    def getStatistic
        : ZIO[Any, AwsError, zio.aws.computeoptimizer.model.MetricStatistic] =
      AwsError.unwrapOptionField("statistic", statistic)
    def getValue: ZIO[Any, AwsError, MetricValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.UtilizationMetric
  ) extends zio.aws.computeoptimizer.model.UtilizationMetric.ReadOnly {
    override val name: Option[zio.aws.computeoptimizer.model.MetricName] = scala
      .Option(impl.name())
      .map(value => zio.aws.computeoptimizer.model.MetricName.wrap(value))
    override val statistic
        : Option[zio.aws.computeoptimizer.model.MetricStatistic] = scala
      .Option(impl.statistic())
      .map(value => zio.aws.computeoptimizer.model.MetricStatistic.wrap(value))
    override val value: Option[MetricValue] = scala
      .Option(impl.value())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.MetricValue(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.UtilizationMetric
  ): zio.aws.computeoptimizer.model.UtilizationMetric.ReadOnly = new Wrapper(
    impl
  )
}
