package zio.aws.computeoptimizer.model
import scala.jdk.CollectionConverters.*
sealed trait MetricName {
  def unwrap: software.amazon.awssdk.services.computeoptimizer.model.MetricName
}
object MetricName {
  def wrap(
      value: software.amazon.awssdk.services.computeoptimizer.model.MetricName
  ): zio.aws.computeoptimizer.model.MetricName = value match {
    case software.amazon.awssdk.services.computeoptimizer.model.MetricName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.computeoptimizer.model.MetricName.CPU =>
      val r = Cpu
      r
    case software.amazon.awssdk.services.computeoptimizer.model.MetricName.MEMORY =>
      val r = Memory
      r
    case software.amazon.awssdk.services.computeoptimizer.model.MetricName.EBS_READ_OPS_PER_SECOND =>
      val r = EBS_READ_OPS_PER_SECOND
      r
    case software.amazon.awssdk.services.computeoptimizer.model.MetricName.EBS_WRITE_OPS_PER_SECOND =>
      val r = EBS_WRITE_OPS_PER_SECOND
      r
    case software.amazon.awssdk.services.computeoptimizer.model.MetricName.EBS_READ_BYTES_PER_SECOND =>
      val r = EBS_READ_BYTES_PER_SECOND
      r
    case software.amazon.awssdk.services.computeoptimizer.model.MetricName.EBS_WRITE_BYTES_PER_SECOND =>
      val r = EBS_WRITE_BYTES_PER_SECOND
      r
    case software.amazon.awssdk.services.computeoptimizer.model.MetricName.DISK_READ_OPS_PER_SECOND =>
      val r = DISK_READ_OPS_PER_SECOND
      r
    case software.amazon.awssdk.services.computeoptimizer.model.MetricName.DISK_WRITE_OPS_PER_SECOND =>
      val r = DISK_WRITE_OPS_PER_SECOND
      r
    case software.amazon.awssdk.services.computeoptimizer.model.MetricName.DISK_READ_BYTES_PER_SECOND =>
      val r = DISK_READ_BYTES_PER_SECOND
      r
    case software.amazon.awssdk.services.computeoptimizer.model.MetricName.DISK_WRITE_BYTES_PER_SECOND =>
      val r = DISK_WRITE_BYTES_PER_SECOND
      r
    case software.amazon.awssdk.services.computeoptimizer.model.MetricName.NETWORK_IN_BYTES_PER_SECOND =>
      val r = NETWORK_IN_BYTES_PER_SECOND
      r
    case software.amazon.awssdk.services.computeoptimizer.model.MetricName.NETWORK_OUT_BYTES_PER_SECOND =>
      val r = NETWORK_OUT_BYTES_PER_SECOND
      r
    case software.amazon.awssdk.services.computeoptimizer.model.MetricName.NETWORK_PACKETS_IN_PER_SECOND =>
      val r = NETWORK_PACKETS_IN_PER_SECOND
      r
    case software.amazon.awssdk.services.computeoptimizer.model.MetricName.NETWORK_PACKETS_OUT_PER_SECOND =>
      val r = NETWORK_PACKETS_OUT_PER_SECOND
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.computeoptimizer.model.MetricName {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.MetricName =
      software.amazon.awssdk.services.computeoptimizer.model.MetricName.UNKNOWN_TO_SDK_VERSION
  }
  case object Cpu extends zio.aws.computeoptimizer.model.MetricName {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.MetricName =
      software.amazon.awssdk.services.computeoptimizer.model.MetricName.CPU
  }
  case object Memory extends zio.aws.computeoptimizer.model.MetricName {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.MetricName =
      software.amazon.awssdk.services.computeoptimizer.model.MetricName.MEMORY
  }
  case object EBS_READ_OPS_PER_SECOND
      extends zio.aws.computeoptimizer.model.MetricName {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.MetricName =
      software.amazon.awssdk.services.computeoptimizer.model.MetricName.EBS_READ_OPS_PER_SECOND
  }
  case object EBS_WRITE_OPS_PER_SECOND
      extends zio.aws.computeoptimizer.model.MetricName {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.MetricName =
      software.amazon.awssdk.services.computeoptimizer.model.MetricName.EBS_WRITE_OPS_PER_SECOND
  }
  case object EBS_READ_BYTES_PER_SECOND
      extends zio.aws.computeoptimizer.model.MetricName {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.MetricName =
      software.amazon.awssdk.services.computeoptimizer.model.MetricName.EBS_READ_BYTES_PER_SECOND
  }
  case object EBS_WRITE_BYTES_PER_SECOND
      extends zio.aws.computeoptimizer.model.MetricName {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.MetricName =
      software.amazon.awssdk.services.computeoptimizer.model.MetricName.EBS_WRITE_BYTES_PER_SECOND
  }
  case object DISK_READ_OPS_PER_SECOND
      extends zio.aws.computeoptimizer.model.MetricName {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.MetricName =
      software.amazon.awssdk.services.computeoptimizer.model.MetricName.DISK_READ_OPS_PER_SECOND
  }
  case object DISK_WRITE_OPS_PER_SECOND
      extends zio.aws.computeoptimizer.model.MetricName {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.MetricName =
      software.amazon.awssdk.services.computeoptimizer.model.MetricName.DISK_WRITE_OPS_PER_SECOND
  }
  case object DISK_READ_BYTES_PER_SECOND
      extends zio.aws.computeoptimizer.model.MetricName {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.MetricName =
      software.amazon.awssdk.services.computeoptimizer.model.MetricName.DISK_READ_BYTES_PER_SECOND
  }
  case object DISK_WRITE_BYTES_PER_SECOND
      extends zio.aws.computeoptimizer.model.MetricName {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.MetricName =
      software.amazon.awssdk.services.computeoptimizer.model.MetricName.DISK_WRITE_BYTES_PER_SECOND
  }
  case object NETWORK_IN_BYTES_PER_SECOND
      extends zio.aws.computeoptimizer.model.MetricName {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.MetricName =
      software.amazon.awssdk.services.computeoptimizer.model.MetricName.NETWORK_IN_BYTES_PER_SECOND
  }
  case object NETWORK_OUT_BYTES_PER_SECOND
      extends zio.aws.computeoptimizer.model.MetricName {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.MetricName =
      software.amazon.awssdk.services.computeoptimizer.model.MetricName.NETWORK_OUT_BYTES_PER_SECOND
  }
  case object NETWORK_PACKETS_IN_PER_SECOND
      extends zio.aws.computeoptimizer.model.MetricName {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.MetricName =
      software.amazon.awssdk.services.computeoptimizer.model.MetricName.NETWORK_PACKETS_IN_PER_SECOND
  }
  case object NETWORK_PACKETS_OUT_PER_SECOND
      extends zio.aws.computeoptimizer.model.MetricName {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.MetricName =
      software.amazon.awssdk.services.computeoptimizer.model.MetricName.NETWORK_PACKETS_OUT_PER_SECOND
  }
}
