package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.computeoptimizer.model.primitives.{
  FailureReason,
  LastUpdatedTimestamp,
  CreationTimestamp,
  JobId
}
import scala.jdk.CollectionConverters.*
final case class RecommendationExportJob(
    jobId: Option[JobId] = None,
    destination: Option[zio.aws.computeoptimizer.model.ExportDestination] =
      None,
    resourceType: Option[zio.aws.computeoptimizer.model.ResourceType] = None,
    status: Option[zio.aws.computeoptimizer.model.JobStatus] = None,
    creationTimestamp: Option[CreationTimestamp] = None,
    lastUpdatedTimestamp: Option[LastUpdatedTimestamp] = None,
    failureReason: Option[FailureReason] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.RecommendationExportJob = {
    import RecommendationExportJob.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.RecommendationExportJob
      .builder()
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(destination.map(value => value.buildAwsValue()))(
        _.destination
      )
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        creationTimestamp.map(value => CreationTimestamp.unwrap(value): Instant)
      )(_.creationTimestamp)
      .optionallyWith(
        lastUpdatedTimestamp.map(value =>
          LastUpdatedTimestamp.unwrap(value): Instant
        )
      )(_.lastUpdatedTimestamp)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.RecommendationExportJob.ReadOnly =
    zio.aws.computeoptimizer.model.RecommendationExportJob.wrap(buildAwsValue())
}
object RecommendationExportJob {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.RecommendationExportJob
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.computeoptimizer.model.RecommendationExportJob =
      zio.aws.computeoptimizer.model.RecommendationExportJob(
        jobId.map(value => value),
        destination.map(value => value.asEditable),
        resourceType.map(value => value),
        status.map(value => value),
        creationTimestamp.map(value => value),
        lastUpdatedTimestamp.map(value => value),
        failureReason.map(value => value)
      )
    def jobId: Option[JobId]
    def destination
        : Option[zio.aws.computeoptimizer.model.ExportDestination.ReadOnly]
    def resourceType: Option[zio.aws.computeoptimizer.model.ResourceType]
    def status: Option[zio.aws.computeoptimizer.model.JobStatus]
    def creationTimestamp: Option[CreationTimestamp]
    def lastUpdatedTimestamp: Option[LastUpdatedTimestamp]
    def failureReason: Option[FailureReason]
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getDestination: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.ExportDestination.ReadOnly
    ] = AwsError.unwrapOptionField("destination", destination)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.computeoptimizer.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.computeoptimizer.model.JobStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreationTimestamp: ZIO[Any, AwsError, CreationTimestamp] =
      AwsError.unwrapOptionField("creationTimestamp", creationTimestamp)
    def getLastUpdatedTimestamp: ZIO[Any, AwsError, LastUpdatedTimestamp] =
      AwsError.unwrapOptionField("lastUpdatedTimestamp", lastUpdatedTimestamp)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.RecommendationExportJob
  ) extends zio.aws.computeoptimizer.model.RecommendationExportJob.ReadOnly {
    override val jobId: Option[JobId] = scala
      .Option(impl.jobId())
      .map(value => zio.aws.computeoptimizer.model.primitives.JobId(value))
    override val destination
        : Option[zio.aws.computeoptimizer.model.ExportDestination.ReadOnly] =
      scala
        .Option(impl.destination())
        .map(value =>
          zio.aws.computeoptimizer.model.ExportDestination.wrap(value)
        )
    override val resourceType
        : Option[zio.aws.computeoptimizer.model.ResourceType] = scala
      .Option(impl.resourceType())
      .map(value => zio.aws.computeoptimizer.model.ResourceType.wrap(value))
    override val status: Option[zio.aws.computeoptimizer.model.JobStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.computeoptimizer.model.JobStatus.wrap(value))
    override val creationTimestamp: Option[CreationTimestamp] = scala
      .Option(impl.creationTimestamp())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.CreationTimestamp(value)
      )
    override val lastUpdatedTimestamp: Option[LastUpdatedTimestamp] = scala
      .Option(impl.lastUpdatedTimestamp())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.LastUpdatedTimestamp(value)
      )
    override val failureReason: Option[FailureReason] = scala
      .Option(impl.failureReason())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.FailureReason(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.RecommendationExportJob
  ): zio.aws.computeoptimizer.model.RecommendationExportJob.ReadOnly =
    new Wrapper(impl)
}
