package zio.aws.computeoptimizer.model
import zio.aws.computeoptimizer.model.primitives.{
  Timestamp,
  Period,
  InstanceArn
}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetEc2RecommendationProjectedMetricsRequest(
    instanceArn: InstanceArn,
    stat: zio.aws.computeoptimizer.model.MetricStatistic,
    period: Period,
    startTime: Timestamp,
    endTime: Timestamp,
    recommendationPreferences: Option[
      zio.aws.computeoptimizer.model.RecommendationPreferences
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.GetEc2RecommendationProjectedMetricsRequest = {
    import GetEc2RecommendationProjectedMetricsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.GetEc2RecommendationProjectedMetricsRequest
      .builder()
      .instanceArn(InstanceArn.unwrap(instanceArn): java.lang.String)
      .stat(stat.unwrap)
      .period(Period.unwrap(period): Integer)
      .startTime(Timestamp.unwrap(startTime): Instant)
      .endTime(Timestamp.unwrap(endTime): Instant)
      .optionallyWith(
        recommendationPreferences.map(value => value.buildAwsValue())
      )(_.recommendationPreferences)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.GetEc2RecommendationProjectedMetricsRequest.ReadOnly =
    zio.aws.computeoptimizer.model.GetEc2RecommendationProjectedMetricsRequest
      .wrap(buildAwsValue())
}
object GetEc2RecommendationProjectedMetricsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.GetEc2RecommendationProjectedMetricsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.GetEc2RecommendationProjectedMetricsRequest =
      zio.aws.computeoptimizer.model
        .GetEc2RecommendationProjectedMetricsRequest(
          instanceArn,
          stat,
          period,
          startTime,
          endTime,
          recommendationPreferences.map(value => value.asEditable)
        )
    def instanceArn: InstanceArn
    def stat: zio.aws.computeoptimizer.model.MetricStatistic
    def period: Period
    def startTime: Timestamp
    def endTime: Timestamp
    def recommendationPreferences: Option[
      zio.aws.computeoptimizer.model.RecommendationPreferences.ReadOnly
    ]
    def getInstanceArn: ZIO[Any, Nothing, InstanceArn] =
      ZIO.succeed(instanceArn)
    def getStat
        : ZIO[Any, Nothing, zio.aws.computeoptimizer.model.MetricStatistic] =
      ZIO.succeed(stat)
    def getPeriod: ZIO[Any, Nothing, Period] = ZIO.succeed(period)
    def getStartTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTime)
    def getEndTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endTime)
    def getRecommendationPreferences: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.RecommendationPreferences.ReadOnly
    ] = AwsError.unwrapOptionField(
      "recommendationPreferences",
      recommendationPreferences
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetEc2RecommendationProjectedMetricsRequest
  ) extends zio.aws.computeoptimizer.model.GetEc2RecommendationProjectedMetricsRequest.ReadOnly {
    override val instanceArn: InstanceArn =
      zio.aws.computeoptimizer.model.primitives.InstanceArn(impl.instanceArn())
    override val stat: zio.aws.computeoptimizer.model.MetricStatistic =
      zio.aws.computeoptimizer.model.MetricStatistic.wrap(impl.stat())
    override val period: Period =
      zio.aws.computeoptimizer.model.primitives.Period(impl.period())
    override val startTime: Timestamp =
      zio.aws.computeoptimizer.model.primitives.Timestamp(impl.startTime())
    override val endTime: Timestamp =
      zio.aws.computeoptimizer.model.primitives.Timestamp(impl.endTime())
    override val recommendationPreferences: Option[
      zio.aws.computeoptimizer.model.RecommendationPreferences.ReadOnly
    ] = scala
      .Option(impl.recommendationPreferences())
      .map(value =>
        zio.aws.computeoptimizer.model.RecommendationPreferences.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetEc2RecommendationProjectedMetricsRequest
  ): zio.aws.computeoptimizer.model.GetEc2RecommendationProjectedMetricsRequest.ReadOnly =
    new Wrapper(impl)
}
