package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RecommendationPreferences(
    cpuVendorArchitectures: Option[
      Iterable[zio.aws.computeoptimizer.model.CpuVendorArchitecture]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.RecommendationPreferences = {
    import RecommendationPreferences.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.RecommendationPreferences
      .builder()
      .optionallyWith(
        cpuVendorArchitectures.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.cpuVendorArchitecturesWithStrings)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.RecommendationPreferences.ReadOnly =
    zio.aws.computeoptimizer.model.RecommendationPreferences
      .wrap(buildAwsValue())
}
object RecommendationPreferences {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.RecommendationPreferences
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.computeoptimizer.model.RecommendationPreferences =
      zio.aws.computeoptimizer.model
        .RecommendationPreferences(cpuVendorArchitectures.map(value => value))
    def cpuVendorArchitectures
        : Option[List[zio.aws.computeoptimizer.model.CpuVendorArchitecture]]
    def getCpuVendorArchitectures: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.CpuVendorArchitecture
    ]] = AwsError.unwrapOptionField(
      "cpuVendorArchitectures",
      cpuVendorArchitectures
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.RecommendationPreferences
  ) extends zio.aws.computeoptimizer.model.RecommendationPreferences.ReadOnly {
    override val cpuVendorArchitectures
        : Option[List[zio.aws.computeoptimizer.model.CpuVendorArchitecture]] =
      scala
        .Option(impl.cpuVendorArchitectures())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.computeoptimizer.model.CpuVendorArchitecture.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.RecommendationPreferences
  ): zio.aws.computeoptimizer.model.RecommendationPreferences.ReadOnly =
    new Wrapper(impl)
}
