package zio.aws.computeoptimizer.model
import zio.aws.computeoptimizer.model.primitives.{
  LastRefreshTimestamp,
  LookBackPeriodInDays,
  AccountId,
  VolumeArn
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class VolumeRecommendation(
    volumeArn: Optional[VolumeArn] = Optional.Absent,
    accountId: Optional[AccountId] = Optional.Absent,
    currentConfiguration: Optional[
      zio.aws.computeoptimizer.model.VolumeConfiguration
    ] = Optional.Absent,
    finding: Optional[zio.aws.computeoptimizer.model.EBSFinding] =
      Optional.Absent,
    utilizationMetrics: Optional[
      Iterable[zio.aws.computeoptimizer.model.EBSUtilizationMetric]
    ] = Optional.Absent,
    lookBackPeriodInDays: Optional[LookBackPeriodInDays] = Optional.Absent,
    volumeRecommendationOptions: Optional[
      Iterable[zio.aws.computeoptimizer.model.VolumeRecommendationOption]
    ] = Optional.Absent,
    lastRefreshTimestamp: Optional[LastRefreshTimestamp] = Optional.Absent,
    currentPerformanceRisk: Optional[
      zio.aws.computeoptimizer.model.CurrentPerformanceRisk
    ] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.computeoptimizer.model.Tag]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.VolumeRecommendation = {
    import VolumeRecommendation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.VolumeRecommendation
      .builder()
      .optionallyWith(
        volumeArn.map(value => VolumeArn.unwrap(value): java.lang.String)
      )(_.volumeArn)
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(currentConfiguration.map(value => value.buildAwsValue()))(
        _.currentConfiguration
      )
      .optionallyWith(finding.map(value => value.unwrap))(_.finding)
      .optionallyWith(
        utilizationMetrics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.utilizationMetrics)
      .optionallyWith(
        lookBackPeriodInDays.map(value =>
          LookBackPeriodInDays.unwrap(value): java.lang.Double
        )
      )(_.lookBackPeriodInDays)
      .optionallyWith(
        volumeRecommendationOptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.volumeRecommendationOptions)
      .optionallyWith(
        lastRefreshTimestamp.map(value =>
          LastRefreshTimestamp.unwrap(value): Instant
        )
      )(_.lastRefreshTimestamp)
      .optionallyWith(currentPerformanceRisk.map(value => value.unwrap))(
        _.currentPerformanceRisk
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.computeoptimizer.model.VolumeRecommendation.ReadOnly =
    zio.aws.computeoptimizer.model.VolumeRecommendation.wrap(buildAwsValue())
}
object VolumeRecommendation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.VolumeRecommendation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.computeoptimizer.model.VolumeRecommendation =
      zio.aws.computeoptimizer.model.VolumeRecommendation(
        volumeArn.map(value => value),
        accountId.map(value => value),
        currentConfiguration.map(value => value.asEditable),
        finding.map(value => value),
        utilizationMetrics.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lookBackPeriodInDays.map(value => value),
        volumeRecommendationOptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lastRefreshTimestamp.map(value => value),
        currentPerformanceRisk.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def volumeArn: Optional[VolumeArn]
    def accountId: Optional[AccountId]
    def currentConfiguration
        : Optional[zio.aws.computeoptimizer.model.VolumeConfiguration.ReadOnly]
    def finding: Optional[zio.aws.computeoptimizer.model.EBSFinding]
    def utilizationMetrics: Optional[
      List[zio.aws.computeoptimizer.model.EBSUtilizationMetric.ReadOnly]
    ]
    def lookBackPeriodInDays: Optional[LookBackPeriodInDays]
    def volumeRecommendationOptions: Optional[
      List[zio.aws.computeoptimizer.model.VolumeRecommendationOption.ReadOnly]
    ]
    def lastRefreshTimestamp: Optional[LastRefreshTimestamp]
    def currentPerformanceRisk
        : Optional[zio.aws.computeoptimizer.model.CurrentPerformanceRisk]
    def tags: Optional[List[zio.aws.computeoptimizer.model.Tag.ReadOnly]]
    def getVolumeArn: ZIO[Any, AwsError, VolumeArn] =
      AwsError.unwrapOptionField("volumeArn", volumeArn)
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getCurrentConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.VolumeConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("currentConfiguration", currentConfiguration)
    def getFinding
        : ZIO[Any, AwsError, zio.aws.computeoptimizer.model.EBSFinding] =
      AwsError.unwrapOptionField("finding", finding)
    def getUtilizationMetrics: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.EBSUtilizationMetric.ReadOnly
    ]] = AwsError.unwrapOptionField("utilizationMetrics", utilizationMetrics)
    def getLookBackPeriodInDays: ZIO[Any, AwsError, LookBackPeriodInDays] =
      AwsError.unwrapOptionField("lookBackPeriodInDays", lookBackPeriodInDays)
    def getVolumeRecommendationOptions: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.VolumeRecommendationOption.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "volumeRecommendationOptions",
      volumeRecommendationOptions
    )
    def getLastRefreshTimestamp: ZIO[Any, AwsError, LastRefreshTimestamp] =
      AwsError.unwrapOptionField("lastRefreshTimestamp", lastRefreshTimestamp)
    def getCurrentPerformanceRisk: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.CurrentPerformanceRisk
    ] = AwsError.unwrapOptionField(
      "currentPerformanceRisk",
      currentPerformanceRisk
    )
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.VolumeRecommendation
  ) extends zio.aws.computeoptimizer.model.VolumeRecommendation.ReadOnly {
    override val volumeArn: Optional[VolumeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeArn())
      .map(value => zio.aws.computeoptimizer.model.primitives.VolumeArn(value))
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.computeoptimizer.model.primitives.AccountId(value))
    override val currentConfiguration: Optional[
      zio.aws.computeoptimizer.model.VolumeConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.currentConfiguration())
      .map(value =>
        zio.aws.computeoptimizer.model.VolumeConfiguration.wrap(value)
      )
    override val finding: Optional[zio.aws.computeoptimizer.model.EBSFinding] =
      zio.aws.core.internal
        .optionalFromNullable(impl.finding())
        .map(value => zio.aws.computeoptimizer.model.EBSFinding.wrap(value))
    override val utilizationMetrics: Optional[
      List[zio.aws.computeoptimizer.model.EBSUtilizationMetric.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.utilizationMetrics())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.EBSUtilizationMetric.wrap(item)
        }.toList
      )
    override val lookBackPeriodInDays: Optional[LookBackPeriodInDays] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lookBackPeriodInDays())
        .map(value =>
          zio.aws.computeoptimizer.model.primitives.LookBackPeriodInDays(value)
        )
    override val volumeRecommendationOptions: Optional[
      List[zio.aws.computeoptimizer.model.VolumeRecommendationOption.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeRecommendationOptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.VolumeRecommendationOption.wrap(item)
        }.toList
      )
    override val lastRefreshTimestamp: Optional[LastRefreshTimestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastRefreshTimestamp())
        .map(value =>
          zio.aws.computeoptimizer.model.primitives.LastRefreshTimestamp(value)
        )
    override val currentPerformanceRisk
        : Optional[zio.aws.computeoptimizer.model.CurrentPerformanceRisk] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentPerformanceRisk())
        .map(value =>
          zio.aws.computeoptimizer.model.CurrentPerformanceRisk.wrap(value)
        )
    override val tags
        : Optional[List[zio.aws.computeoptimizer.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.computeoptimizer.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.VolumeRecommendation
  ): zio.aws.computeoptimizer.model.VolumeRecommendation.ReadOnly = new Wrapper(
    impl
  )
}
