package zio.aws.computeoptimizer.model
import scala.jdk.CollectionConverters._
sealed trait LicenseFindingReasonCode {
  def unwrap: software.amazon.awssdk.services.computeoptimizer.model.LicenseFindingReasonCode
}
object LicenseFindingReasonCode {
  def wrap(
      value: software.amazon.awssdk.services.computeoptimizer.model.LicenseFindingReasonCode
  ): zio.aws.computeoptimizer.model.LicenseFindingReasonCode = value match {
    case software.amazon.awssdk.services.computeoptimizer.model.LicenseFindingReasonCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.computeoptimizer.model.LicenseFindingReasonCode.INVALID_CLOUD_WATCH_APPLICATION_INSIGHTS_SETUP =>
      val r = InvalidCloudWatchApplicationInsightsSetup
      r
    case software.amazon.awssdk.services.computeoptimizer.model.LicenseFindingReasonCode.CLOUD_WATCH_APPLICATION_INSIGHTS_ERROR =>
      val r = CloudWatchApplicationInsightsError
      r
    case software.amazon.awssdk.services.computeoptimizer.model.LicenseFindingReasonCode.LICENSE_OVERPROVISIONED =>
      val r = LicenseOverprovisioned
      r
    case software.amazon.awssdk.services.computeoptimizer.model.LicenseFindingReasonCode.OPTIMIZED =>
      val r = Optimized
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.computeoptimizer.model.LicenseFindingReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.LicenseFindingReasonCode =
      software.amazon.awssdk.services.computeoptimizer.model.LicenseFindingReasonCode.UNKNOWN_TO_SDK_VERSION
  }
  case object InvalidCloudWatchApplicationInsightsSetup
      extends zio.aws.computeoptimizer.model.LicenseFindingReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.LicenseFindingReasonCode =
      software.amazon.awssdk.services.computeoptimizer.model.LicenseFindingReasonCode.INVALID_CLOUD_WATCH_APPLICATION_INSIGHTS_SETUP
  }
  case object CloudWatchApplicationInsightsError
      extends zio.aws.computeoptimizer.model.LicenseFindingReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.LicenseFindingReasonCode =
      software.amazon.awssdk.services.computeoptimizer.model.LicenseFindingReasonCode.CLOUD_WATCH_APPLICATION_INSIGHTS_ERROR
  }
  case object LicenseOverprovisioned
      extends zio.aws.computeoptimizer.model.LicenseFindingReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.LicenseFindingReasonCode =
      software.amazon.awssdk.services.computeoptimizer.model.LicenseFindingReasonCode.LICENSE_OVERPROVISIONED
  }
  case object Optimized
      extends zio.aws.computeoptimizer.model.LicenseFindingReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.LicenseFindingReasonCode =
      software.amazon.awssdk.services.computeoptimizer.model.LicenseFindingReasonCode.OPTIMIZED
  }
}
