package zio.aws.computeoptimizer.model
import scala.jdk.CollectionConverters._
sealed trait LambdaFunctionMetricStatistic {
  def unwrap: software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionMetricStatistic
}
object LambdaFunctionMetricStatistic {
  def wrap(
      value: software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionMetricStatistic
  ): zio.aws.computeoptimizer.model.LambdaFunctionMetricStatistic =
    value match {
      case software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionMetricStatistic.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionMetricStatistic.MAXIMUM =>
        val r = Maximum
        r
      case software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionMetricStatistic.AVERAGE =>
        val r = Average
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.computeoptimizer.model.LambdaFunctionMetricStatistic {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionMetricStatistic =
      software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionMetricStatistic.UNKNOWN_TO_SDK_VERSION
  }
  case object Maximum
      extends zio.aws.computeoptimizer.model.LambdaFunctionMetricStatistic {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionMetricStatistic =
      software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionMetricStatistic.MAXIMUM
  }
  case object Average
      extends zio.aws.computeoptimizer.model.LambdaFunctionMetricStatistic {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionMetricStatistic =
      software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionMetricStatistic.AVERAGE
  }
}
