package zio.aws.computeoptimizer.model
import zio.aws.computeoptimizer.model.primitives.{
  Rank,
  PerformanceRisk,
  InstanceType
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class InstanceRecommendationOption(
    instanceType: Optional[InstanceType] = Optional.Absent,
    projectedUtilizationMetrics: Optional[
      Iterable[zio.aws.computeoptimizer.model.UtilizationMetric]
    ] = Optional.Absent,
    platformDifferences: Optional[
      Iterable[zio.aws.computeoptimizer.model.PlatformDifference]
    ] = Optional.Absent,
    performanceRisk: Optional[PerformanceRisk] = Optional.Absent,
    rank: Optional[Rank] = Optional.Absent,
    savingsOpportunity: Optional[
      zio.aws.computeoptimizer.model.SavingsOpportunity
    ] = Optional.Absent,
    migrationEffort: Optional[zio.aws.computeoptimizer.model.MigrationEffort] =
      Optional.Absent,
    instanceGpuInfo: Optional[zio.aws.computeoptimizer.model.GpuInfo] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationOption = {
    import InstanceRecommendationOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationOption
      .builder()
      .optionallyWith(
        instanceType.map(value => InstanceType.unwrap(value): java.lang.String)
      )(_.instanceType)
      .optionallyWith(
        projectedUtilizationMetrics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.projectedUtilizationMetrics)
      .optionallyWith(
        platformDifferences.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.platformDifferencesWithStrings)
      .optionallyWith(
        performanceRisk.map(value =>
          PerformanceRisk.unwrap(value): java.lang.Double
        )
      )(_.performanceRisk)
      .optionallyWith(rank.map(value => Rank.unwrap(value): Integer))(_.rank)
      .optionallyWith(savingsOpportunity.map(value => value.buildAwsValue()))(
        _.savingsOpportunity
      )
      .optionallyWith(migrationEffort.map(value => value.unwrap))(
        _.migrationEffort
      )
      .optionallyWith(instanceGpuInfo.map(value => value.buildAwsValue()))(
        _.instanceGpuInfo
      )
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.InstanceRecommendationOption.ReadOnly =
    zio.aws.computeoptimizer.model.InstanceRecommendationOption
      .wrap(buildAwsValue())
}
object InstanceRecommendationOption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationOption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.InstanceRecommendationOption =
      zio.aws.computeoptimizer.model.InstanceRecommendationOption(
        instanceType.map(value => value),
        projectedUtilizationMetrics.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        platformDifferences.map(value => value),
        performanceRisk.map(value => value),
        rank.map(value => value),
        savingsOpportunity.map(value => value.asEditable),
        migrationEffort.map(value => value),
        instanceGpuInfo.map(value => value.asEditable)
      )
    def instanceType: Optional[InstanceType]
    def projectedUtilizationMetrics: Optional[
      List[zio.aws.computeoptimizer.model.UtilizationMetric.ReadOnly]
    ]
    def platformDifferences
        : Optional[List[zio.aws.computeoptimizer.model.PlatformDifference]]
    def performanceRisk: Optional[PerformanceRisk]
    def rank: Optional[Rank]
    def savingsOpportunity
        : Optional[zio.aws.computeoptimizer.model.SavingsOpportunity.ReadOnly]
    def migrationEffort
        : Optional[zio.aws.computeoptimizer.model.MigrationEffort]
    def instanceGpuInfo
        : Optional[zio.aws.computeoptimizer.model.GpuInfo.ReadOnly]
    def getInstanceType: ZIO[Any, AwsError, InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getProjectedUtilizationMetrics: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.UtilizationMetric.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "projectedUtilizationMetrics",
      projectedUtilizationMetrics
    )
    def getPlatformDifferences: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.PlatformDifference
    ]] = AwsError.unwrapOptionField("platformDifferences", platformDifferences)
    def getPerformanceRisk: ZIO[Any, AwsError, PerformanceRisk] =
      AwsError.unwrapOptionField("performanceRisk", performanceRisk)
    def getRank: ZIO[Any, AwsError, Rank] =
      AwsError.unwrapOptionField("rank", rank)
    def getSavingsOpportunity: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.SavingsOpportunity.ReadOnly
    ] = AwsError.unwrapOptionField("savingsOpportunity", savingsOpportunity)
    def getMigrationEffort
        : ZIO[Any, AwsError, zio.aws.computeoptimizer.model.MigrationEffort] =
      AwsError.unwrapOptionField("migrationEffort", migrationEffort)
    def getInstanceGpuInfo
        : ZIO[Any, AwsError, zio.aws.computeoptimizer.model.GpuInfo.ReadOnly] =
      AwsError.unwrapOptionField("instanceGpuInfo", instanceGpuInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationOption
  ) extends zio.aws.computeoptimizer.model.InstanceRecommendationOption.ReadOnly {
    override val instanceType: Optional[InstanceType] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceType())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.InstanceType(value)
      )
    override val projectedUtilizationMetrics: Optional[
      List[zio.aws.computeoptimizer.model.UtilizationMetric.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.projectedUtilizationMetrics())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.UtilizationMetric.wrap(item)
        }.toList
      )
    override val platformDifferences
        : Optional[List[zio.aws.computeoptimizer.model.PlatformDifference]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platformDifferences())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.computeoptimizer.model.PlatformDifference.wrap(item)
          }.toList
        )
    override val performanceRisk: Optional[PerformanceRisk] =
      zio.aws.core.internal
        .optionalFromNullable(impl.performanceRisk())
        .map(value =>
          zio.aws.computeoptimizer.model.primitives.PerformanceRisk(value)
        )
    override val rank: Optional[Rank] = zio.aws.core.internal
      .optionalFromNullable(impl.rank())
      .map(value => zio.aws.computeoptimizer.model.primitives.Rank(value))
    override val savingsOpportunity
        : Optional[zio.aws.computeoptimizer.model.SavingsOpportunity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.savingsOpportunity())
        .map(value =>
          zio.aws.computeoptimizer.model.SavingsOpportunity.wrap(value)
        )
    override val migrationEffort
        : Optional[zio.aws.computeoptimizer.model.MigrationEffort] =
      zio.aws.core.internal
        .optionalFromNullable(impl.migrationEffort())
        .map(value =>
          zio.aws.computeoptimizer.model.MigrationEffort.wrap(value)
        )
    override val instanceGpuInfo
        : Optional[zio.aws.computeoptimizer.model.GpuInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceGpuInfo())
        .map(value => zio.aws.computeoptimizer.model.GpuInfo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationOption
  ): zio.aws.computeoptimizer.model.InstanceRecommendationOption.ReadOnly =
    new Wrapper(impl)
}
