package zio.aws.computeoptimizer.model
import scala.jdk.CollectionConverters._
sealed trait InstanceIdle {
  def unwrap
      : software.amazon.awssdk.services.computeoptimizer.model.InstanceIdle
}
object InstanceIdle {
  def wrap(
      value: software.amazon.awssdk.services.computeoptimizer.model.InstanceIdle
  ): zio.aws.computeoptimizer.model.InstanceIdle = value match {
    case software.amazon.awssdk.services.computeoptimizer.model.InstanceIdle.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.computeoptimizer.model.InstanceIdle.TRUE =>
      val r = True
      r
    case software.amazon.awssdk.services.computeoptimizer.model.InstanceIdle.FALSE =>
      val r = False
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.computeoptimizer.model.InstanceIdle {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.InstanceIdle =
      software.amazon.awssdk.services.computeoptimizer.model.InstanceIdle.UNKNOWN_TO_SDK_VERSION
  }
  case object True extends zio.aws.computeoptimizer.model.InstanceIdle {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.InstanceIdle =
      software.amazon.awssdk.services.computeoptimizer.model.InstanceIdle.TRUE
  }
  case object False extends zio.aws.computeoptimizer.model.InstanceIdle {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.InstanceIdle =
      software.amazon.awssdk.services.computeoptimizer.model.InstanceIdle.FALSE
  }
}
